@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.CookieExpirationArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.CookieExpirationConvention
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The configuration settings of the session cookie's expiration.
 * @property convention The convention used when determining the session cookie's expiration.
 * @property timeToExpiration The time after the request is made when the session cookie should expire.
 */
public data class CookieExpirationArgs(
    public val convention: Output<CookieExpirationConvention>? = null,
    public val timeToExpiration: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.CookieExpirationArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.CookieExpirationArgs =
        com.pulumi.azurenative.app.inputs.CookieExpirationArgs.builder()
            .convention(convention?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeToExpiration(timeToExpiration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CookieExpirationArgs].
 */
@PulumiTagMarker
public class CookieExpirationArgsBuilder internal constructor() {
    private var convention: Output<CookieExpirationConvention>? = null

    private var timeToExpiration: Output<String>? = null

    /**
     * @param value The convention used when determining the session cookie's expiration.
     */
    @JvmName("feqsxyjqhgsduogp")
    public suspend fun convention(`value`: Output<CookieExpirationConvention>) {
        this.convention = value
    }

    /**
     * @param value The time after the request is made when the session cookie should expire.
     */
    @JvmName("meuclfijckuhymbr")
    public suspend fun timeToExpiration(`value`: Output<String>) {
        this.timeToExpiration = value
    }

    /**
     * @param value The convention used when determining the session cookie's expiration.
     */
    @JvmName("fywceukxlirdlgxm")
    public suspend fun convention(`value`: CookieExpirationConvention?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.convention = mapped
    }

    /**
     * @param value The time after the request is made when the session cookie should expire.
     */
    @JvmName("pewxjxryjdgffnkj")
    public suspend fun timeToExpiration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeToExpiration = mapped
    }

    internal fun build(): CookieExpirationArgs = CookieExpirationArgs(
        convention = convention,
        timeToExpiration = timeToExpiration,
    )
}
