@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.CorsPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Cross-Origin-Resource-Sharing policy
 * @property allowCredentials allow credential or not
 * @property allowedHeaders allowed HTTP headers
 * @property allowedMethods allowed HTTP methods
 * @property allowedOrigins allowed origins
 * @property exposeHeaders expose HTTP headers
 * @property maxAge max time client can cache the result
 */
public data class CorsPolicyArgs(
    public val allowCredentials: Output<Boolean>? = null,
    public val allowedHeaders: Output<List<String>>? = null,
    public val allowedMethods: Output<List<String>>? = null,
    public val allowedOrigins: Output<List<String>>,
    public val exposeHeaders: Output<List<String>>? = null,
    public val maxAge: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.CorsPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.CorsPolicyArgs =
        com.pulumi.azurenative.app.inputs.CorsPolicyArgs.builder()
            .allowCredentials(allowCredentials?.applyValue({ args0 -> args0 }))
            .allowedHeaders(allowedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedMethods(allowedMethods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedOrigins(allowedOrigins.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exposeHeaders(exposeHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxAge(maxAge?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CorsPolicyArgs].
 */
@PulumiTagMarker
public class CorsPolicyArgsBuilder internal constructor() {
    private var allowCredentials: Output<Boolean>? = null

    private var allowedHeaders: Output<List<String>>? = null

    private var allowedMethods: Output<List<String>>? = null

    private var allowedOrigins: Output<List<String>>? = null

    private var exposeHeaders: Output<List<String>>? = null

    private var maxAge: Output<Int>? = null

    /**
     * @param value allow credential or not
     */
    @JvmName("gkhmncorhvaxrrrx")
    public suspend fun allowCredentials(`value`: Output<Boolean>) {
        this.allowCredentials = value
    }

    /**
     * @param value allowed HTTP headers
     */
    @JvmName("vsyillbwekvgknem")
    public suspend fun allowedHeaders(`value`: Output<List<String>>) {
        this.allowedHeaders = value
    }

    @JvmName("hrjxbfsdmppdsydn")
    public suspend fun allowedHeaders(vararg values: Output<String>) {
        this.allowedHeaders = Output.all(values.asList())
    }

    /**
     * @param values allowed HTTP headers
     */
    @JvmName("yjxafwkulvfaofwt")
    public suspend fun allowedHeaders(values: List<Output<String>>) {
        this.allowedHeaders = Output.all(values)
    }

    /**
     * @param value allowed HTTP methods
     */
    @JvmName("afnnnqxeekdhaaty")
    public suspend fun allowedMethods(`value`: Output<List<String>>) {
        this.allowedMethods = value
    }

    @JvmName("ffyuvdufrtlhhhhs")
    public suspend fun allowedMethods(vararg values: Output<String>) {
        this.allowedMethods = Output.all(values.asList())
    }

    /**
     * @param values allowed HTTP methods
     */
    @JvmName("iqfuflspshatukri")
    public suspend fun allowedMethods(values: List<Output<String>>) {
        this.allowedMethods = Output.all(values)
    }

    /**
     * @param value allowed origins
     */
    @JvmName("soctvohxdopsowyy")
    public suspend fun allowedOrigins(`value`: Output<List<String>>) {
        this.allowedOrigins = value
    }

    @JvmName("ducjnktsxviffpev")
    public suspend fun allowedOrigins(vararg values: Output<String>) {
        this.allowedOrigins = Output.all(values.asList())
    }

    /**
     * @param values allowed origins
     */
    @JvmName("hrtrldiuaadaokjy")
    public suspend fun allowedOrigins(values: List<Output<String>>) {
        this.allowedOrigins = Output.all(values)
    }

    /**
     * @param value expose HTTP headers
     */
    @JvmName("mciuxojtwwmjhvxa")
    public suspend fun exposeHeaders(`value`: Output<List<String>>) {
        this.exposeHeaders = value
    }

    @JvmName("ycmqleopqwlqtntt")
    public suspend fun exposeHeaders(vararg values: Output<String>) {
        this.exposeHeaders = Output.all(values.asList())
    }

    /**
     * @param values expose HTTP headers
     */
    @JvmName("esgmxrlpxfvjoacf")
    public suspend fun exposeHeaders(values: List<Output<String>>) {
        this.exposeHeaders = Output.all(values)
    }

    /**
     * @param value max time client can cache the result
     */
    @JvmName("eycfvhdmathlreqy")
    public suspend fun maxAge(`value`: Output<Int>) {
        this.maxAge = value
    }

    /**
     * @param value allow credential or not
     */
    @JvmName("gskfjhbwughbdtqn")
    public suspend fun allowCredentials(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowCredentials = mapped
    }

    /**
     * @param value allowed HTTP headers
     */
    @JvmName("sinxuuvxbxuxgoau")
    public suspend fun allowedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param values allowed HTTP headers
     */
    @JvmName("aelpigtqxlnshehe")
    public suspend fun allowedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param value allowed HTTP methods
     */
    @JvmName("ctmatvkhtpxljdnk")
    public suspend fun allowedMethods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param values allowed HTTP methods
     */
    @JvmName("vprheodxpgvgjvge")
    public suspend fun allowedMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param value allowed origins
     */
    @JvmName("qxcbwjybwbxkfoeo")
    public suspend fun allowedOrigins(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param values allowed origins
     */
    @JvmName("xbsfkvliplodqyxc")
    public suspend fun allowedOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param value expose HTTP headers
     */
    @JvmName("leiswsivetkgytqk")
    public suspend fun exposeHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param values expose HTTP headers
     */
    @JvmName("achxwetqqhqonnah")
    public suspend fun exposeHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param value max time client can cache the result
     */
    @JvmName("daythntghnvgbeqt")
    public suspend fun maxAge(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAge = mapped
    }

    internal fun build(): CorsPolicyArgs = CorsPolicyArgs(
        allowCredentials = allowCredentials,
        allowedHeaders = allowedHeaders,
        allowedMethods = allowedMethods,
        allowedOrigins = allowedOrigins ?: throw PulumiNullFieldException("allowedOrigins"),
        exposeHeaders = exposeHeaders,
        maxAge = maxAge,
    )
}
