@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.CustomScaleRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Container App container Custom scaling rule.
 * @property auth Authentication secrets for the custom scale rule.
 * @property metadata Metadata properties to describe custom scale rule.
 * @property type Type of the custom scale rule
 * eg: azure-servicebus, redis etc.
 */
public data class CustomScaleRuleArgs(
    public val auth: Output<List<ScaleRuleAuthArgs>>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.CustomScaleRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.CustomScaleRuleArgs =
        com.pulumi.azurenative.app.inputs.CustomScaleRuleArgs.builder()
            .auth(auth?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomScaleRuleArgs].
 */
@PulumiTagMarker
public class CustomScaleRuleArgsBuilder internal constructor() {
    private var auth: Output<List<ScaleRuleAuthArgs>>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Authentication secrets for the custom scale rule.
     */
    @JvmName("rvyiuunukiasrkwi")
    public suspend fun auth(`value`: Output<List<ScaleRuleAuthArgs>>) {
        this.auth = value
    }

    @JvmName("rassbldhbsvgyswf")
    public suspend fun auth(vararg values: Output<ScaleRuleAuthArgs>) {
        this.auth = Output.all(values.asList())
    }

    /**
     * @param values Authentication secrets for the custom scale rule.
     */
    @JvmName("guwkdhhpcaapuhye")
    public suspend fun auth(values: List<Output<ScaleRuleAuthArgs>>) {
        this.auth = Output.all(values)
    }

    /**
     * @param value Metadata properties to describe custom scale rule.
     */
    @JvmName("dapqnaanwdajmvwj")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value Type of the custom scale rule
     * eg: azure-servicebus, redis etc.
     */
    @JvmName("wbdxnrbflktagbwr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Authentication secrets for the custom scale rule.
     */
    @JvmName("lqccaauhxudmjeeu")
    public suspend fun auth(`value`: List<ScaleRuleAuthArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auth = mapped
    }

    /**
     * @param argument Authentication secrets for the custom scale rule.
     */
    @JvmName("jvqcbfyidojvkwiy")
    public suspend fun auth(argument: List<suspend ScaleRuleAuthArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScaleRuleAuthArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param argument Authentication secrets for the custom scale rule.
     */
    @JvmName("vfdjryhrylgvkamr")
    public suspend fun auth(vararg argument: suspend ScaleRuleAuthArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScaleRuleAuthArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param argument Authentication secrets for the custom scale rule.
     */
    @JvmName("xbjfklclxiklsrsn")
    public suspend fun auth(argument: suspend ScaleRuleAuthArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScaleRuleAuthArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param values Authentication secrets for the custom scale rule.
     */
    @JvmName("iwcfwmrnfytarfqv")
    public suspend fun auth(vararg values: ScaleRuleAuthArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auth = mapped
    }

    /**
     * @param value Metadata properties to describe custom scale rule.
     */
    @JvmName("fdsiqcexabyhlcuu")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values Metadata properties to describe custom scale rule.
     */
    @JvmName("vnjrryaegmhxqyoy")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value Type of the custom scale rule
     * eg: azure-servicebus, redis etc.
     */
    @JvmName("lphsiyadhnxudmny")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): CustomScaleRuleArgs = CustomScaleRuleArgs(
        auth = auth,
        metadata = metadata,
        type = type,
    )
}
