@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Dapr Component Resiliency Policy Timeout Policy Configuration.
 * @property responseTimeoutInSeconds The optional response timeout in seconds
 */
public data class DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs(
    public val responseTimeoutInSeconds: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs =
        com.pulumi.azurenative.app.inputs.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs.builder()
            .responseTimeoutInSeconds(responseTimeoutInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs].
 */
@PulumiTagMarker
public class DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgsBuilder internal
constructor() {
    private var responseTimeoutInSeconds: Output<Int>? = null

    /**
     * @param value The optional response timeout in seconds
     */
    @JvmName("njjchwtaxosurqcm")
    public suspend fun responseTimeoutInSeconds(`value`: Output<Int>) {
        this.responseTimeoutInSeconds = value
    }

    /**
     * @param value The optional response timeout in seconds
     */
    @JvmName("eackusldulhwpsny")
    public suspend fun responseTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseTimeoutInSeconds = mapped
    }

    internal fun build(): DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs =
        DaprComponentResiliencyPolicyTimeoutPolicyConfigurationArgs(
            responseTimeoutInSeconds = responseTimeoutInSeconds,
        )
}
