@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.DaprMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Dapr component metadata.
 * @property name Metadata property name.
 * @property secretRef Name of the Dapr Component secret from which to pull the metadata property value.
 * @property value Metadata property value.
 */
public data class DaprMetadataArgs(
    public val name: Output<String>? = null,
    public val secretRef: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.DaprMetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.DaprMetadataArgs =
        com.pulumi.azurenative.app.inputs.DaprMetadataArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .secretRef(secretRef?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DaprMetadataArgs].
 */
@PulumiTagMarker
public class DaprMetadataArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var secretRef: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Metadata property name.
     */
    @JvmName("hsomtchcxadwcldl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the Dapr Component secret from which to pull the metadata property value.
     */
    @JvmName("fnnarurwexqphwqp")
    public suspend fun secretRef(`value`: Output<String>) {
        this.secretRef = value
    }

    /**
     * @param value Metadata property value.
     */
    @JvmName("urxpiistwanexomy")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Metadata property name.
     */
    @JvmName("vwqcyyibbtmmcjkk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the Dapr Component secret from which to pull the metadata property value.
     */
    @JvmName("pqbvuubuneylcopu")
    public suspend fun secretRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretRef = mapped
    }

    /**
     * @param value Metadata property value.
     */
    @JvmName("pehtevuuxbxcgkpg")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): DaprMetadataArgs = DaprMetadataArgs(
        name = name,
        secretRef = secretRef,
        `value` = `value`,
    )
}
