@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetAppResiliencyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appName Name of the Container App.
 * @property name Name of the resiliency policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAppResiliencyPlainArgs(
    public val appName: String,
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetAppResiliencyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetAppResiliencyPlainArgs =
        com.pulumi.azurenative.app.inputs.GetAppResiliencyPlainArgs.builder()
            .appName(appName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAppResiliencyPlainArgs].
 */
@PulumiTagMarker
public class GetAppResiliencyPlainArgsBuilder internal constructor() {
    private var appName: String? = null

    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Container App.
     */
    @JvmName("mflvqwfdfxvkyxio")
    public suspend fun appName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appName = mapped
    }

    /**
     * @param value Name of the resiliency policy.
     */
    @JvmName("klqvblisolwplauq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lwmluhjemojalawa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAppResiliencyPlainArgs = GetAppResiliencyPlainArgs(
        appName = appName ?: throw PulumiNullFieldException("appName"),
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
