@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetContainerAppPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerAppName Name of the Container App.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetContainerAppPlainArgs(
    public val containerAppName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetContainerAppPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetContainerAppPlainArgs =
        com.pulumi.azurenative.app.inputs.GetContainerAppPlainArgs.builder()
            .containerAppName(containerAppName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContainerAppPlainArgs].
 */
@PulumiTagMarker
public class GetContainerAppPlainArgsBuilder internal constructor() {
    private var containerAppName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Container App.
     */
    @JvmName("ngivdnqmhgcalpaq")
    public suspend fun containerAppName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerAppName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("khgsfsqerxotvbiv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetContainerAppPlainArgs = GetContainerAppPlainArgs(
        containerAppName = containerAppName ?: throw PulumiNullFieldException("containerAppName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
