@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetContainerAppsSourceControlPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerAppName Name of the Container App.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sourceControlName Name of the Container App SourceControl.
 */
public data class GetContainerAppsSourceControlPlainArgs(
    public val containerAppName: String,
    public val resourceGroupName: String,
    public val sourceControlName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetContainerAppsSourceControlPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetContainerAppsSourceControlPlainArgs =
        com.pulumi.azurenative.app.inputs.GetContainerAppsSourceControlPlainArgs.builder()
            .containerAppName(containerAppName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sourceControlName(sourceControlName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContainerAppsSourceControlPlainArgs].
 */
@PulumiTagMarker
public class GetContainerAppsSourceControlPlainArgsBuilder internal constructor() {
    private var containerAppName: String? = null

    private var resourceGroupName: String? = null

    private var sourceControlName: String? = null

    /**
     * @param value Name of the Container App.
     */
    @JvmName("etrtjmaanggvbcii")
    public suspend fun containerAppName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerAppName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kbjtuqbnfacuhwla")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Container App SourceControl.
     */
    @JvmName("cwgexgtqkthoefgt")
    public suspend fun sourceControlName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourceControlName = mapped
    }

    internal fun build(): GetContainerAppsSourceControlPlainArgs =
        GetContainerAppsSourceControlPlainArgs(
            containerAppName = containerAppName ?: throw PulumiNullFieldException("containerAppName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            sourceControlName = sourceControlName ?: throw PulumiNullFieldException("sourceControlName"),
        )
}
