@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetManagedCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentName Name of the Managed Environment.
 * @property managedCertificateName Name of the Managed Certificate.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetManagedCertificatePlainArgs(
    public val environmentName: String,
    public val managedCertificateName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetManagedCertificatePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetManagedCertificatePlainArgs =
        com.pulumi.azurenative.app.inputs.GetManagedCertificatePlainArgs.builder()
            .environmentName(environmentName.let({ args0 -> args0 }))
            .managedCertificateName(managedCertificateName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetManagedCertificatePlainArgsBuilder internal constructor() {
    private var environmentName: String? = null

    private var managedCertificateName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("qbixochgrcdpghco")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value Name of the Managed Certificate.
     */
    @JvmName("dpitbrrnqjddjaae")
    public suspend fun managedCertificateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedCertificateName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("essrvoeumtgtekyc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedCertificatePlainArgs = GetManagedCertificatePlainArgs(
        environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
        managedCertificateName = managedCertificateName ?: throw
            PulumiNullFieldException("managedCertificateName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
