@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.HeaderMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Conditions required to match a header
 * @property exactMatch Exact value of the header
 * @property header Name of the header
 * @property prefixMatch Prefix value of the header
 * @property regexMatch Regex value of the header
 * @property suffixMatch Suffix value of the header
 */
public data class HeaderMatchArgs(
    public val exactMatch: Output<String>? = null,
    public val `header`: Output<String>? = null,
    public val prefixMatch: Output<String>? = null,
    public val regexMatch: Output<String>? = null,
    public val suffixMatch: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.HeaderMatchArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.HeaderMatchArgs =
        com.pulumi.azurenative.app.inputs.HeaderMatchArgs.builder()
            .exactMatch(exactMatch?.applyValue({ args0 -> args0 }))
            .`header`(`header`?.applyValue({ args0 -> args0 }))
            .prefixMatch(prefixMatch?.applyValue({ args0 -> args0 }))
            .regexMatch(regexMatch?.applyValue({ args0 -> args0 }))
            .suffixMatch(suffixMatch?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HeaderMatchArgs].
 */
@PulumiTagMarker
public class HeaderMatchArgsBuilder internal constructor() {
    private var exactMatch: Output<String>? = null

    private var `header`: Output<String>? = null

    private var prefixMatch: Output<String>? = null

    private var regexMatch: Output<String>? = null

    private var suffixMatch: Output<String>? = null

    /**
     * @param value Exact value of the header
     */
    @JvmName("xlqbrwcjphmlparc")
    public suspend fun exactMatch(`value`: Output<String>) {
        this.exactMatch = value
    }

    /**
     * @param value Name of the header
     */
    @JvmName("omgirtqvfmdwrahu")
    public suspend fun `header`(`value`: Output<String>) {
        this.`header` = value
    }

    /**
     * @param value Prefix value of the header
     */
    @JvmName("swxrwxhtkfaprdij")
    public suspend fun prefixMatch(`value`: Output<String>) {
        this.prefixMatch = value
    }

    /**
     * @param value Regex value of the header
     */
    @JvmName("tbuvmrfinyqfixor")
    public suspend fun regexMatch(`value`: Output<String>) {
        this.regexMatch = value
    }

    /**
     * @param value Suffix value of the header
     */
    @JvmName("mldhxbiataiosfsg")
    public suspend fun suffixMatch(`value`: Output<String>) {
        this.suffixMatch = value
    }

    /**
     * @param value Exact value of the header
     */
    @JvmName("tvhnnoscmooenohu")
    public suspend fun exactMatch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exactMatch = mapped
    }

    /**
     * @param value Name of the header
     */
    @JvmName("klgcfgkiabthwdif")
    public suspend fun `header`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`header` = mapped
    }

    /**
     * @param value Prefix value of the header
     */
    @JvmName("clxqjpcnjhsnorhn")
    public suspend fun prefixMatch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixMatch = mapped
    }

    /**
     * @param value Regex value of the header
     */
    @JvmName("fmxwuyxopnmfrsup")
    public suspend fun regexMatch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexMatch = mapped
    }

    /**
     * @param value Suffix value of the header
     */
    @JvmName("xtdportonkpfrbks")
    public suspend fun suffixMatch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suffixMatch = mapped
    }

    internal fun build(): HeaderMatchArgs = HeaderMatchArgs(
        exactMatch = exactMatch,
        `header` = `header`,
        prefixMatch = prefixMatch,
        regexMatch = regexMatch,
        suffixMatch = suffixMatch,
    )
}
