@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.HttpRetryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Policy that defines http request retry conditions
 * @property errors Errors that can trigger a retry
 * @property headers Headers that must be present for a request to be retried
 * @property httpStatusCodes Additional http status codes that can trigger a retry
 * @property initialDelayInMilliseconds Initial delay, in milliseconds, before retrying a request
 * @property maxIntervalInMilliseconds Maximum interval, in milliseconds, between retries
 * @property maxRetries Maximum number of times a request will retry
 */
public data class HttpRetryPolicyArgs(
    public val errors: Output<List<String>>? = null,
    public val headers: Output<List<HeaderMatchArgs>>? = null,
    public val httpStatusCodes: Output<List<Int>>? = null,
    public val initialDelayInMilliseconds: Output<Double>? = null,
    public val maxIntervalInMilliseconds: Output<Double>? = null,
    public val maxRetries: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.HttpRetryPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.HttpRetryPolicyArgs =
        com.pulumi.azurenative.app.inputs.HttpRetryPolicyArgs.builder()
            .errors(errors?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .httpStatusCodes(httpStatusCodes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .initialDelayInMilliseconds(initialDelayInMilliseconds?.applyValue({ args0 -> args0 }))
            .maxIntervalInMilliseconds(maxIntervalInMilliseconds?.applyValue({ args0 -> args0 }))
            .maxRetries(maxRetries?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpRetryPolicyArgs].
 */
@PulumiTagMarker
public class HttpRetryPolicyArgsBuilder internal constructor() {
    private var errors: Output<List<String>>? = null

    private var headers: Output<List<HeaderMatchArgs>>? = null

    private var httpStatusCodes: Output<List<Int>>? = null

    private var initialDelayInMilliseconds: Output<Double>? = null

    private var maxIntervalInMilliseconds: Output<Double>? = null

    private var maxRetries: Output<Int>? = null

    /**
     * @param value Errors that can trigger a retry
     */
    @JvmName("rnavwmilrciiqjnc")
    public suspend fun errors(`value`: Output<List<String>>) {
        this.errors = value
    }

    @JvmName("solmrjfmwrculnpk")
    public suspend fun errors(vararg values: Output<String>) {
        this.errors = Output.all(values.asList())
    }

    /**
     * @param values Errors that can trigger a retry
     */
    @JvmName("umbrjrcekywhfird")
    public suspend fun errors(values: List<Output<String>>) {
        this.errors = Output.all(values)
    }

    /**
     * @param value Headers that must be present for a request to be retried
     */
    @JvmName("oehwxfvqserulncf")
    public suspend fun headers(`value`: Output<List<HeaderMatchArgs>>) {
        this.headers = value
    }

    @JvmName("ogbocntuocahhkbs")
    public suspend fun headers(vararg values: Output<HeaderMatchArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Headers that must be present for a request to be retried
     */
    @JvmName("qpqgrpbwmefmtplj")
    public suspend fun headers(values: List<Output<HeaderMatchArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Additional http status codes that can trigger a retry
     */
    @JvmName("ibobstxotoocyugr")
    public suspend fun httpStatusCodes(`value`: Output<List<Int>>) {
        this.httpStatusCodes = value
    }

    @JvmName("xsqjmrdinjwlyrwh")
    public suspend fun httpStatusCodes(vararg values: Output<Int>) {
        this.httpStatusCodes = Output.all(values.asList())
    }

    /**
     * @param values Additional http status codes that can trigger a retry
     */
    @JvmName("hgmiveujyuxtpamn")
    public suspend fun httpStatusCodes(values: List<Output<Int>>) {
        this.httpStatusCodes = Output.all(values)
    }

    /**
     * @param value Initial delay, in milliseconds, before retrying a request
     */
    @JvmName("ydfjcsdtkvpchoxp")
    public suspend fun initialDelayInMilliseconds(`value`: Output<Double>) {
        this.initialDelayInMilliseconds = value
    }

    /**
     * @param value Maximum interval, in milliseconds, between retries
     */
    @JvmName("bxatbsvabhivneyf")
    public suspend fun maxIntervalInMilliseconds(`value`: Output<Double>) {
        this.maxIntervalInMilliseconds = value
    }

    /**
     * @param value Maximum number of times a request will retry
     */
    @JvmName("puopqoscrjspoqtl")
    public suspend fun maxRetries(`value`: Output<Int>) {
        this.maxRetries = value
    }

    /**
     * @param value Errors that can trigger a retry
     */
    @JvmName("ybhnwapnxmymurxn")
    public suspend fun errors(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errors = mapped
    }

    /**
     * @param values Errors that can trigger a retry
     */
    @JvmName("ljrexnfqrkhkrioy")
    public suspend fun errors(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errors = mapped
    }

    /**
     * @param value Headers that must be present for a request to be retried
     */
    @JvmName("krcsbxyeggtgtjyi")
    public suspend fun headers(`value`: List<HeaderMatchArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Headers that must be present for a request to be retried
     */
    @JvmName("tjfbjabmbdoxjkaf")
    public suspend fun headers(argument: List<suspend HeaderMatchArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { HeaderMatchArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Headers that must be present for a request to be retried
     */
    @JvmName("wunoavpiugwfotsn")
    public suspend fun headers(vararg argument: suspend HeaderMatchArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { HeaderMatchArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Headers that must be present for a request to be retried
     */
    @JvmName("jrfjkqnjahhrpoaa")
    public suspend fun headers(argument: suspend HeaderMatchArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HeaderMatchArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Headers that must be present for a request to be retried
     */
    @JvmName("nrxkaoxwipnwxyua")
    public suspend fun headers(vararg values: HeaderMatchArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Additional http status codes that can trigger a retry
     */
    @JvmName("yjygljqjjxuwdxqa")
    public suspend fun httpStatusCodes(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpStatusCodes = mapped
    }

    /**
     * @param values Additional http status codes that can trigger a retry
     */
    @JvmName("kbxnqrjxgjqbvpwe")
    public suspend fun httpStatusCodes(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpStatusCodes = mapped
    }

    /**
     * @param value Initial delay, in milliseconds, before retrying a request
     */
    @JvmName("jjgbwhaxwcfbgnob")
    public suspend fun initialDelayInMilliseconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDelayInMilliseconds = mapped
    }

    /**
     * @param value Maximum interval, in milliseconds, between retries
     */
    @JvmName("bwrlgmqqfosysylw")
    public suspend fun maxIntervalInMilliseconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxIntervalInMilliseconds = mapped
    }

    /**
     * @param value Maximum number of times a request will retry
     */
    @JvmName("ysnylxknmwfwiaty")
    public suspend fun maxRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRetries = mapped
    }

    internal fun build(): HttpRetryPolicyArgs = HttpRetryPolicyArgs(
        errors = errors,
        headers = headers,
        httpStatusCodes = httpStatusCodes,
        initialDelayInMilliseconds = initialDelayInMilliseconds,
        maxIntervalInMilliseconds = maxIntervalInMilliseconds,
        maxRetries = maxRetries,
    )
}
