@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.IngressArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.IngressClientCertificateMode
import com.pulumi.azurenative.app.kotlin.enums.IngressTransportMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container App Ingress configuration.
 * @property allowInsecure Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
 * @property clientCertificateMode Client certificate mode for mTLS authentication. Ignore indicates server drops client certificate on forwarding. Accept indicates server forwards client certificate but does not require a client certificate. Require indicates server requires a client certificate.
 * @property corsPolicy CORS policy for container app
 * @property customDomains custom domain bindings for Container Apps' hostnames.
 * @property exposedPort Exposed Port in containers for TCP traffic from ingress
 * @property external Bool indicating if app exposes an external http endpoint
 * @property ipSecurityRestrictions Rules to restrict incoming IP address.
 * @property targetPort Target Port in containers for traffic from ingress
 * @property traffic Traffic weights for app's revisions
 * @property transport Ingress transport protocol
 */
public data class IngressArgs(
    public val allowInsecure: Output<Boolean>? = null,
    public val clientCertificateMode: Output<Either<String, IngressClientCertificateMode>>? = null,
    public val corsPolicy: Output<CorsPolicyArgs>? = null,
    public val customDomains: Output<List<CustomDomainArgs>>? = null,
    public val exposedPort: Output<Int>? = null,
    public val `external`: Output<Boolean>? = null,
    public val ipSecurityRestrictions: Output<List<IpSecurityRestrictionRuleArgs>>? = null,
    public val targetPort: Output<Int>? = null,
    public val traffic: Output<List<TrafficWeightArgs>>? = null,
    public val transport: Output<Either<String, IngressTransportMethod>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.IngressArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.IngressArgs =
        com.pulumi.azurenative.app.inputs.IngressArgs.builder()
            .allowInsecure(allowInsecure?.applyValue({ args0 -> args0 }))
            .clientCertificateMode(
                clientCertificateMode?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .corsPolicy(corsPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customDomains(
                customDomains?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .exposedPort(exposedPort?.applyValue({ args0 -> args0 }))
            .`external`(`external`?.applyValue({ args0 -> args0 }))
            .ipSecurityRestrictions(
                ipSecurityRestrictions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetPort(targetPort?.applyValue({ args0 -> args0 }))
            .traffic(
                traffic?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .transport(
                transport?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [IngressArgs].
 */
@PulumiTagMarker
public class IngressArgsBuilder internal constructor() {
    private var allowInsecure: Output<Boolean>? = null

    private var clientCertificateMode: Output<Either<String, IngressClientCertificateMode>>? = null

    private var corsPolicy: Output<CorsPolicyArgs>? = null

    private var customDomains: Output<List<CustomDomainArgs>>? = null

    private var exposedPort: Output<Int>? = null

    private var `external`: Output<Boolean>? = null

    private var ipSecurityRestrictions: Output<List<IpSecurityRestrictionRuleArgs>>? = null

    private var targetPort: Output<Int>? = null

    private var traffic: Output<List<TrafficWeightArgs>>? = null

    private var transport: Output<Either<String, IngressTransportMethod>>? = null

    /**
     * @param value Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
     */
    @JvmName("gkjidhdnkynexvek")
    public suspend fun allowInsecure(`value`: Output<Boolean>) {
        this.allowInsecure = value
    }

    /**
     * @param value Client certificate mode for mTLS authentication. Ignore indicates server drops client certificate on forwarding. Accept indicates server forwards client certificate but does not require a client certificate. Require indicates server requires a client certificate.
     */
    @JvmName("lbssqpbvrtheqsdl")
    public suspend
    fun clientCertificateMode(`value`: Output<Either<String, IngressClientCertificateMode>>) {
        this.clientCertificateMode = value
    }

    /**
     * @param value CORS policy for container app
     */
    @JvmName("senvrwadwofcieyv")
    public suspend fun corsPolicy(`value`: Output<CorsPolicyArgs>) {
        this.corsPolicy = value
    }

    /**
     * @param value custom domain bindings for Container Apps' hostnames.
     */
    @JvmName("jkkjifcvrclusyxq")
    public suspend fun customDomains(`value`: Output<List<CustomDomainArgs>>) {
        this.customDomains = value
    }

    @JvmName("fkahhlficlywqmxu")
    public suspend fun customDomains(vararg values: Output<CustomDomainArgs>) {
        this.customDomains = Output.all(values.asList())
    }

    /**
     * @param values custom domain bindings for Container Apps' hostnames.
     */
    @JvmName("qiuwpemghcwhycdy")
    public suspend fun customDomains(values: List<Output<CustomDomainArgs>>) {
        this.customDomains = Output.all(values)
    }

    /**
     * @param value Exposed Port in containers for TCP traffic from ingress
     */
    @JvmName("mxekylbgyyhdkxfg")
    public suspend fun exposedPort(`value`: Output<Int>) {
        this.exposedPort = value
    }

    /**
     * @param value Bool indicating if app exposes an external http endpoint
     */
    @JvmName("cwgbyrkipktbewkn")
    public suspend fun `external`(`value`: Output<Boolean>) {
        this.`external` = value
    }

    /**
     * @param value Rules to restrict incoming IP address.
     */
    @JvmName("dtikqecrnhiqyhdr")
    public suspend fun ipSecurityRestrictions(`value`: Output<List<IpSecurityRestrictionRuleArgs>>) {
        this.ipSecurityRestrictions = value
    }

    @JvmName("hykdhlpucjpgyogw")
    public suspend fun ipSecurityRestrictions(vararg values: Output<IpSecurityRestrictionRuleArgs>) {
        this.ipSecurityRestrictions = Output.all(values.asList())
    }

    /**
     * @param values Rules to restrict incoming IP address.
     */
    @JvmName("jiogdqkemvigftpp")
    public suspend fun ipSecurityRestrictions(values: List<Output<IpSecurityRestrictionRuleArgs>>) {
        this.ipSecurityRestrictions = Output.all(values)
    }

    /**
     * @param value Target Port in containers for traffic from ingress
     */
    @JvmName("ikdrogkxjnkctgjm")
    public suspend fun targetPort(`value`: Output<Int>) {
        this.targetPort = value
    }

    /**
     * @param value Traffic weights for app's revisions
     */
    @JvmName("pnqqjdnxobvujtqg")
    public suspend fun traffic(`value`: Output<List<TrafficWeightArgs>>) {
        this.traffic = value
    }

    @JvmName("qcgwciuiwmmgaqsf")
    public suspend fun traffic(vararg values: Output<TrafficWeightArgs>) {
        this.traffic = Output.all(values.asList())
    }

    /**
     * @param values Traffic weights for app's revisions
     */
    @JvmName("btdjsjjknijmckpn")
    public suspend fun traffic(values: List<Output<TrafficWeightArgs>>) {
        this.traffic = Output.all(values)
    }

    /**
     * @param value Ingress transport protocol
     */
    @JvmName("alumomnbiuvamwjb")
    public suspend fun transport(`value`: Output<Either<String, IngressTransportMethod>>) {
        this.transport = value
    }

    /**
     * @param value Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
     */
    @JvmName("bkhumtcfrppgxpup")
    public suspend fun allowInsecure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowInsecure = mapped
    }

    /**
     * @param value Client certificate mode for mTLS authentication. Ignore indicates server drops client certificate on forwarding. Accept indicates server forwards client certificate but does not require a client certificate. Require indicates server requires a client certificate.
     */
    @JvmName("bdqqopwditxfqkki")
    public suspend fun clientCertificateMode(`value`: Either<String, IngressClientCertificateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificateMode = mapped
    }

    /**
     * @param value Client certificate mode for mTLS authentication. Ignore indicates server drops client certificate on forwarding. Accept indicates server forwards client certificate but does not require a client certificate. Require indicates server requires a client certificate.
     */
    @JvmName("papqsktlifmmmfcu")
    public fun clientCertificateMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IngressClientCertificateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientCertificateMode = mapped
    }

    /**
     * @param value Client certificate mode for mTLS authentication. Ignore indicates server drops client certificate on forwarding. Accept indicates server forwards client certificate but does not require a client certificate. Require indicates server requires a client certificate.
     */
    @JvmName("tjqtsigxxpcntnky")
    public fun clientCertificateMode(`value`: IngressClientCertificateMode) {
        val toBeMapped = Either.ofRight<String, IngressClientCertificateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientCertificateMode = mapped
    }

    /**
     * @param value CORS policy for container app
     */
    @JvmName("dmleotuhebgxdywn")
    public suspend fun corsPolicy(`value`: CorsPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsPolicy = mapped
    }

    /**
     * @param argument CORS policy for container app
     */
    @JvmName("yxremyqdnphrcbvq")
    public suspend fun corsPolicy(argument: suspend CorsPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = CorsPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.corsPolicy = mapped
    }

    /**
     * @param value custom domain bindings for Container Apps' hostnames.
     */
    @JvmName("soeqmbkppirtsqfg")
    public suspend fun customDomains(`value`: List<CustomDomainArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDomains = mapped
    }

    /**
     * @param argument custom domain bindings for Container Apps' hostnames.
     */
    @JvmName("eysnfcxjrcrdwrtj")
    public suspend fun customDomains(argument: List<suspend CustomDomainArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomDomainArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customDomains = mapped
    }

    /**
     * @param argument custom domain bindings for Container Apps' hostnames.
     */
    @JvmName("khysdoukywiruwju")
    public suspend fun customDomains(vararg argument: suspend CustomDomainArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            CustomDomainArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customDomains = mapped
    }

    /**
     * @param argument custom domain bindings for Container Apps' hostnames.
     */
    @JvmName("coikhfavnqectcbt")
    public suspend fun customDomains(argument: suspend CustomDomainArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CustomDomainArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.customDomains = mapped
    }

    /**
     * @param values custom domain bindings for Container Apps' hostnames.
     */
    @JvmName("hisfjbnokbvrxapj")
    public suspend fun customDomains(vararg values: CustomDomainArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDomains = mapped
    }

    /**
     * @param value Exposed Port in containers for TCP traffic from ingress
     */
    @JvmName("arxabysdsxuheguo")
    public suspend fun exposedPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposedPort = mapped
    }

    /**
     * @param value Bool indicating if app exposes an external http endpoint
     */
    @JvmName("msikvkgakwktqcrb")
    public suspend fun `external`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`external` = mapped
    }

    /**
     * @param value Rules to restrict incoming IP address.
     */
    @JvmName("axgbfqjcyvmymqrk")
    public suspend fun ipSecurityRestrictions(`value`: List<IpSecurityRestrictionRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param argument Rules to restrict incoming IP address.
     */
    @JvmName("jomchnqgvssysvkp")
    public suspend
    fun ipSecurityRestrictions(argument: List<suspend IpSecurityRestrictionRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpSecurityRestrictionRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param argument Rules to restrict incoming IP address.
     */
    @JvmName("onpggbjrwyspbtbg")
    public suspend fun ipSecurityRestrictions(
        vararg
        argument: suspend IpSecurityRestrictionRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IpSecurityRestrictionRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param argument Rules to restrict incoming IP address.
     */
    @JvmName("vxlllewhnhfepgiy")
    public suspend
    fun ipSecurityRestrictions(argument: suspend IpSecurityRestrictionRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IpSecurityRestrictionRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param values Rules to restrict incoming IP address.
     */
    @JvmName("vnnyjengcaiepsis")
    public suspend fun ipSecurityRestrictions(vararg values: IpSecurityRestrictionRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSecurityRestrictions = mapped
    }

    /**
     * @param value Target Port in containers for traffic from ingress
     */
    @JvmName("urkoxbmxsjrttxsg")
    public suspend fun targetPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPort = mapped
    }

    /**
     * @param value Traffic weights for app's revisions
     */
    @JvmName("mjlovatybeaknxjm")
    public suspend fun traffic(`value`: List<TrafficWeightArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.traffic = mapped
    }

    /**
     * @param argument Traffic weights for app's revisions
     */
    @JvmName("rxnvakfmskctqbpo")
    public suspend fun traffic(argument: List<suspend TrafficWeightArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrafficWeightArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.traffic = mapped
    }

    /**
     * @param argument Traffic weights for app's revisions
     */
    @JvmName("tosiwejonqbbukrm")
    public suspend fun traffic(vararg argument: suspend TrafficWeightArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TrafficWeightArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.traffic = mapped
    }

    /**
     * @param argument Traffic weights for app's revisions
     */
    @JvmName("frbgcuivachopqud")
    public suspend fun traffic(argument: suspend TrafficWeightArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrafficWeightArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.traffic = mapped
    }

    /**
     * @param values Traffic weights for app's revisions
     */
    @JvmName("gnbwfanopnaogtio")
    public suspend fun traffic(vararg values: TrafficWeightArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.traffic = mapped
    }

    /**
     * @param value Ingress transport protocol
     */
    @JvmName("vjrmweqolcmeyufe")
    public suspend fun transport(`value`: Either<String, IngressTransportMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transport = mapped
    }

    /**
     * @param value Ingress transport protocol
     */
    @JvmName("helhuqcqarxvqknn")
    public fun transport(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IngressTransportMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transport = mapped
    }

    /**
     * @param value Ingress transport protocol
     */
    @JvmName("dlahxaimwbpvjqaf")
    public fun transport(`value`: IngressTransportMethod) {
        val toBeMapped = Either.ofRight<String, IngressTransportMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transport = mapped
    }

    internal fun build(): IngressArgs = IngressArgs(
        allowInsecure = allowInsecure,
        clientCertificateMode = clientCertificateMode,
        corsPolicy = corsPolicy,
        customDomains = customDomains,
        exposedPort = exposedPort,
        `external` = `external`,
        ipSecurityRestrictions = ipSecurityRestrictions,
        targetPort = targetPort,
        traffic = traffic,
        transport = transport,
    )
}
