@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.IpSecurityRestrictionRuleArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.Action
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Rule to restrict incoming IP address.
 * @property action Allow or Deny rules to determine for incoming IP. Note: Rules can only consist of ALL Allow or ALL Deny
 * @property description Describe the IP restriction rule that is being sent to the container-app. This is an optional field.
 * @property ipAddressRange CIDR notation to match incoming IP address
 * @property name Name for the IP restriction rule.
 */
public data class IpSecurityRestrictionRuleArgs(
    public val action: Output<Either<String, Action>>,
    public val description: Output<String>? = null,
    public val ipAddressRange: Output<String>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.IpSecurityRestrictionRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.IpSecurityRestrictionRuleArgs =
        com.pulumi.azurenative.app.inputs.IpSecurityRestrictionRuleArgs.builder()
            .action(
                action.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .ipAddressRange(ipAddressRange.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpSecurityRestrictionRuleArgs].
 */
@PulumiTagMarker
public class IpSecurityRestrictionRuleArgsBuilder internal constructor() {
    private var action: Output<Either<String, Action>>? = null

    private var description: Output<String>? = null

    private var ipAddressRange: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Allow or Deny rules to determine for incoming IP. Note: Rules can only consist of ALL Allow or ALL Deny
     */
    @JvmName("ojqhnfejvpantflt")
    public suspend fun action(`value`: Output<Either<String, Action>>) {
        this.action = value
    }

    /**
     * @param value Describe the IP restriction rule that is being sent to the container-app. This is an optional field.
     */
    @JvmName("rqvsfqngbntthcwj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value CIDR notation to match incoming IP address
     */
    @JvmName("yeibndxcrosdtlop")
    public suspend fun ipAddressRange(`value`: Output<String>) {
        this.ipAddressRange = value
    }

    /**
     * @param value Name for the IP restriction rule.
     */
    @JvmName("rledekrmvhrjfuit")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Allow or Deny rules to determine for incoming IP. Note: Rules can only consist of ALL Allow or ALL Deny
     */
    @JvmName("mfqumibunwexkego")
    public suspend fun action(`value`: Either<String, Action>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Allow or Deny rules to determine for incoming IP. Note: Rules can only consist of ALL Allow or ALL Deny
     */
    @JvmName("aapxrkwmiayunwnf")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Action>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Allow or Deny rules to determine for incoming IP. Note: Rules can only consist of ALL Allow or ALL Deny
     */
    @JvmName("pveiihrkhhxivsaf")
    public fun action(`value`: Action) {
        val toBeMapped = Either.ofRight<String, Action>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describe the IP restriction rule that is being sent to the container-app. This is an optional field.
     */
    @JvmName("vadosiynoclycifs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value CIDR notation to match incoming IP address
     */
    @JvmName("yaspmsatopgoemov")
    public suspend fun ipAddressRange(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddressRange = mapped
    }

    /**
     * @param value Name for the IP restriction rule.
     */
    @JvmName("eouwglrdxphofocg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): IpSecurityRestrictionRuleArgs = IpSecurityRestrictionRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        description = description,
        ipAddressRange = ipAddressRange ?: throw PulumiNullFieldException("ipAddressRange"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
