@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.JavaComponentConfigurationPropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration properties for a Java Component
 * @property propertyName The name of the property
 * @property value The value of the property
 */
public data class JavaComponentConfigurationPropertyArgs(
    public val propertyName: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.JavaComponentConfigurationPropertyArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.JavaComponentConfigurationPropertyArgs =
        com.pulumi.azurenative.app.inputs.JavaComponentConfigurationPropertyArgs.builder()
            .propertyName(propertyName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JavaComponentConfigurationPropertyArgs].
 */
@PulumiTagMarker
public class JavaComponentConfigurationPropertyArgsBuilder internal constructor() {
    private var propertyName: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the property
     */
    @JvmName("stfwvboqnxxphawx")
    public suspend fun propertyName(`value`: Output<String>) {
        this.propertyName = value
    }

    /**
     * @param value The value of the property
     */
    @JvmName("nttnxjbojmooirdj")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the property
     */
    @JvmName("pcnluegrwekodsdm")
    public suspend fun propertyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyName = mapped
    }

    /**
     * @param value The value of the property
     */
    @JvmName("lkhwoxaklpimvvuf")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): JavaComponentConfigurationPropertyArgs =
        JavaComponentConfigurationPropertyArgs(
            propertyName = propertyName,
            `value` = `value`,
        )
}
