@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ListBuildAuthTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property buildName The name of a build.
 * @property builderName The name of the builder.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListBuildAuthTokenPlainArgs(
    public val buildName: String,
    public val builderName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ListBuildAuthTokenPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ListBuildAuthTokenPlainArgs =
        com.pulumi.azurenative.app.inputs.ListBuildAuthTokenPlainArgs.builder()
            .buildName(buildName.let({ args0 -> args0 }))
            .builderName(builderName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListBuildAuthTokenPlainArgs].
 */
@PulumiTagMarker
public class ListBuildAuthTokenPlainArgsBuilder internal constructor() {
    private var buildName: String? = null

    private var builderName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of a build.
     */
    @JvmName("inmmfnbahifjvrdr")
    public suspend fun buildName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.buildName = mapped
    }

    /**
     * @param value The name of the builder.
     */
    @JvmName("iebyiooauwndittm")
    public suspend fun builderName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.builderName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wxkfaxntmarxehcb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListBuildAuthTokenPlainArgs = ListBuildAuthTokenPlainArgs(
        buildName = buildName ?: throw PulumiNullFieldException("buildName"),
        builderName = builderName ?: throw PulumiNullFieldException("builderName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
