@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ListJobSecretsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobName Job Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListJobSecretsPlainArgs(
    public val jobName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ListJobSecretsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ListJobSecretsPlainArgs =
        com.pulumi.azurenative.app.inputs.ListJobSecretsPlainArgs.builder()
            .jobName(jobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListJobSecretsPlainArgs].
 */
@PulumiTagMarker
public class ListJobSecretsPlainArgsBuilder internal constructor() {
    private var jobName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Job Name
     */
    @JvmName("aercynwmrqyrxxib")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sogldychnsfwpcdx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListJobSecretsPlainArgs = ListJobSecretsPlainArgs(
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
