@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ManagedEnvironmentStoragePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Storage properties
 * @property azureFile Azure file properties
 */
public data class ManagedEnvironmentStoragePropertiesArgs(
    public val azureFile: Output<AzureFilePropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ManagedEnvironmentStoragePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ManagedEnvironmentStoragePropertiesArgs =
        com.pulumi.azurenative.app.inputs.ManagedEnvironmentStoragePropertiesArgs.builder()
            .azureFile(azureFile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ManagedEnvironmentStoragePropertiesArgs].
 */
@PulumiTagMarker
public class ManagedEnvironmentStoragePropertiesArgsBuilder internal constructor() {
    private var azureFile: Output<AzureFilePropertiesArgs>? = null

    /**
     * @param value Azure file properties
     */
    @JvmName("hqjcygmadibdjesd")
    public suspend fun azureFile(`value`: Output<AzureFilePropertiesArgs>) {
        this.azureFile = value
    }

    /**
     * @param value Azure file properties
     */
    @JvmName("popywccynsoadwxm")
    public suspend fun azureFile(`value`: AzureFilePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFile = mapped
    }

    /**
     * @param argument Azure file properties
     */
    @JvmName("qjwiyjlpxvucjpxy")
    public suspend fun azureFile(argument: suspend AzureFilePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFilePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureFile = mapped
    }

    internal fun build(): ManagedEnvironmentStoragePropertiesArgs =
        ManagedEnvironmentStoragePropertiesArgs(
            azureFile = azureFile,
        )
}
