@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.TimeoutPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Policy to set request timeouts
 * @property connectionTimeoutInSeconds Timeout, in seconds, for a request to initiate a connection
 * @property responseTimeoutInSeconds Timeout, in seconds, for a request to respond
 */
public data class TimeoutPolicyArgs(
    public val connectionTimeoutInSeconds: Output<Int>? = null,
    public val responseTimeoutInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.TimeoutPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.TimeoutPolicyArgs =
        com.pulumi.azurenative.app.inputs.TimeoutPolicyArgs.builder()
            .connectionTimeoutInSeconds(connectionTimeoutInSeconds?.applyValue({ args0 -> args0 }))
            .responseTimeoutInSeconds(responseTimeoutInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TimeoutPolicyArgs].
 */
@PulumiTagMarker
public class TimeoutPolicyArgsBuilder internal constructor() {
    private var connectionTimeoutInSeconds: Output<Int>? = null

    private var responseTimeoutInSeconds: Output<Int>? = null

    /**
     * @param value Timeout, in seconds, for a request to initiate a connection
     */
    @JvmName("hwcyxaqixkykwnui")
    public suspend fun connectionTimeoutInSeconds(`value`: Output<Int>) {
        this.connectionTimeoutInSeconds = value
    }

    /**
     * @param value Timeout, in seconds, for a request to respond
     */
    @JvmName("txccpapuxilwltdp")
    public suspend fun responseTimeoutInSeconds(`value`: Output<Int>) {
        this.responseTimeoutInSeconds = value
    }

    /**
     * @param value Timeout, in seconds, for a request to initiate a connection
     */
    @JvmName("gbshywvdtwaqwktb")
    public suspend fun connectionTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionTimeoutInSeconds = mapped
    }

    /**
     * @param value Timeout, in seconds, for a request to respond
     */
    @JvmName("nsgljfcpncismrrr")
    public suspend fun responseTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseTimeoutInSeconds = mapped
    }

    internal fun build(): TimeoutPolicyArgs = TimeoutPolicyArgs(
        connectionTimeoutInSeconds = connectionTimeoutInSeconds,
        responseTimeoutInSeconds = responseTimeoutInSeconds,
    )
}
