@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the registration for the Apple provider
 * @property clientId The Client ID of the app used for login.
 * @property clientSecretSettingName The app setting name that contains the client secret.
 */
public data class AppleRegistrationResponse(
    public val clientId: String? = null,
    public val clientSecretSettingName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.AppleRegistrationResponse):
            AppleRegistrationResponse = AppleRegistrationResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecretSettingName = javaType.clientSecretSettingName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
