@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the Azure Active Directory app registration.
 * @property clientId The Client ID of this relying party application, known as the client_id.
 * This setting is required for enabling OpenID Connection authentication with Azure Active Directory or
 * other 3rd party OpenID Connect providers.
 * More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
 * @property clientSecretCertificateIssuer An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property acts as
 * a replacement for the Client Secret Certificate Thumbprint. It is also optional.
 * @property clientSecretCertificateSubjectAlternativeName An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing purposes. This property acts as
 * a replacement for the Client Secret Certificate Thumbprint. It is also optional.
 * @property clientSecretCertificateThumbprint An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
 * a replacement for the Client Secret. It is also optional.
 * @property clientSecretSettingName The app setting name that contains the client secret of the relying party application.
 * @property openIdIssuer The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
 * When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://login.microsoftonline.com/v2.0/{tenant-guid}/.
 * This URI is a case-sensitive identifier for the token issuer.
 * More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
 */
public data class AzureActiveDirectoryRegistrationResponse(
    public val clientId: String? = null,
    public val clientSecretCertificateIssuer: String? = null,
    public val clientSecretCertificateSubjectAlternativeName: String? = null,
    public val clientSecretCertificateThumbprint: String? = null,
    public val clientSecretSettingName: String? = null,
    public val openIdIssuer: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.AzureActiveDirectoryRegistrationResponse):
            AzureActiveDirectoryRegistrationResponse = AzureActiveDirectoryRegistrationResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecretCertificateIssuer = javaType.clientSecretCertificateIssuer().map({ args0 ->
                args0
            }).orElse(null),
            clientSecretCertificateSubjectAlternativeName = javaType.clientSecretCertificateSubjectAlternativeName().map({ args0 ->
                args0
            }).orElse(null),
            clientSecretCertificateThumbprint = javaType.clientSecretCertificateThumbprint().map({ args0 ->
                args0
            }).orElse(null),
            clientSecretSettingName = javaType.clientSecretSettingName().map({ args0 -> args0 }).orElse(null),
            openIdIssuer = javaType.openIdIssuer().map({ args0 -> args0 }).orElse(null),
        )
    }
}
