@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Suppress

/**
 * Dapr Component Resiliency Policy Configuration.
 * @property httpRetryPolicy The optional HTTP retry policy configuration
 * @property timeoutPolicy The optional timeout policy configuration
 */
public data class DaprComponentResiliencyPolicyConfigurationResponse(
    public val httpRetryPolicy: DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationResponse? =
        null,
    public val timeoutPolicy: DaprComponentResiliencyPolicyTimeoutPolicyConfigurationResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.DaprComponentResiliencyPolicyConfigurationResponse):
            DaprComponentResiliencyPolicyConfigurationResponse =
            DaprComponentResiliencyPolicyConfigurationResponse(
                httpRetryPolicy = javaType.httpRetryPolicy().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.DaprComponentResiliencyPolicyHttpRetryPolicyConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                timeoutPolicy = javaType.timeoutPolicy().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.DaprComponentResiliencyPolicyTimeoutPolicyConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
