@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Container App Dapr configuration.
 * @property appId Dapr application identifier
 * @property appPort Tells Dapr which port your application is listening on
 * @property appProtocol Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
 * @property enableApiLogging Enables API logging for the Dapr sidecar
 * @property enabled Boolean indicating if the Dapr side car is enabled
 * @property httpMaxRequestSize Increasing max size of request body http and grpc servers parameter in MB to handle uploading of big files. Default is 4 MB.
 * @property httpReadBufferSize Dapr max size of http header read buffer in KB to handle when sending multi-KB headers. Default is 65KB.
 * @property logLevel Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info.
 */
public data class DaprResponse(
    public val appId: String? = null,
    public val appPort: Int? = null,
    public val appProtocol: String? = null,
    public val enableApiLogging: Boolean? = null,
    public val enabled: Boolean? = null,
    public val httpMaxRequestSize: Int? = null,
    public val httpReadBufferSize: Int? = null,
    public val logLevel: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.DaprResponse): DaprResponse =
            DaprResponse(
                appId = javaType.appId().map({ args0 -> args0 }).orElse(null),
                appPort = javaType.appPort().map({ args0 -> args0 }).orElse(null),
                appProtocol = javaType.appProtocol().map({ args0 -> args0 }).orElse(null),
                enableApiLogging = javaType.enableApiLogging().map({ args0 -> args0 }).orElse(null),
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                httpMaxRequestSize = javaType.httpMaxRequestSize().map({ args0 -> args0 }).orElse(null),
                httpReadBufferSize = javaType.httpReadBufferSize().map({ args0 -> args0 }).orElse(null),
                logLevel = javaType.logLevel().map({ args0 -> args0 }).orElse(null),
            )
    }
}
