@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration settings for the Azure ContainerApp Service Authentication / Authorization feature.
 * @property globalValidation The configuration settings that determines the validation flow of users using  Service Authentication/Authorization.
 * @property httpSettings The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identityProviders The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization.
 * @property login The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
 * @property name The name of the resource
 * @property platform The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetContainerAppsAuthConfigResult(
    public val globalValidation: GlobalValidationResponse? = null,
    public val httpSettings: HttpSettingsResponse? = null,
    public val id: String,
    public val identityProviders: IdentityProvidersResponse? = null,
    public val login: LoginResponse? = null,
    public val name: String,
    public val platform: AuthPlatformResponse? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GetContainerAppsAuthConfigResult):
            GetContainerAppsAuthConfigResult = GetContainerAppsAuthConfigResult(
            globalValidation = javaType.globalValidation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.GlobalValidationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            httpSettings = javaType.httpSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.HttpSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identityProviders = javaType.identityProviders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.IdentityProvidersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            login = javaType.login().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.LoginResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            platform = javaType.platform().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.AuthPlatformResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
