@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Container App SourceControl.
 * @property branch The branch which will trigger the auto deployment
 * @property githubActionConfiguration Container App Revision Template with all possible settings and the
 * defaults if user did not provide them. The defaults are populated
 * as they were at the creation time
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property operationState Current provisioning State of the operation
 * @property repoUrl The repo url which will be integrated to ContainerApp.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetContainerAppsSourceControlResult(
    public val branch: String? = null,
    public val githubActionConfiguration: GithubActionConfigurationResponse? = null,
    public val id: String,
    public val name: String,
    public val operationState: String,
    public val repoUrl: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GetContainerAppsSourceControlResult):
            GetContainerAppsSourceControlResult = GetContainerAppsSourceControlResult(
            branch = javaType.branch().map({ args0 -> args0 }).orElse(null),
            githubActionConfiguration = javaType.githubActionConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.GithubActionConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            operationState = javaType.operationState(),
            repoUrl = javaType.repoUrl().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
