@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Dapr Component Resiliency Policy.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property inboundPolicy The optional inbound component resiliency policy configuration
 * @property name The name of the resource
 * @property outboundPolicy The optional outbound component resiliency policy configuration
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDaprComponentResiliencyPolicyResult(
    public val id: String,
    public val inboundPolicy: DaprComponentResiliencyPolicyConfigurationResponse? = null,
    public val name: String,
    public val outboundPolicy: DaprComponentResiliencyPolicyConfigurationResponse? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GetDaprComponentResiliencyPolicyResult):
            GetDaprComponentResiliencyPolicyResult = GetDaprComponentResiliencyPolicyResult(
            id = javaType.id(),
            inboundPolicy = javaType.inboundPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.DaprComponentResiliencyPolicyConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            outboundPolicy = javaType.outboundPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.DaprComponentResiliencyPolicyConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
