@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Container App Job
 * @property configuration Container Apps Job configuration properties.
 * @property environmentId Resource ID of environment.
 * @property eventStreamEndpoint The endpoint of the eventstream of the container apps job.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Managed identities needed by a container app job to interact with other Azure services to not maintain any secrets or credentials in code.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property outboundIpAddresses Outbound IP Addresses of a container apps job.
 * @property provisioningState Provisioning state of the Container Apps Job.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property template Container Apps job definition.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property workloadProfileName Workload profile name to pin for container apps job execution.
 */
public data class GetJobResult(
    public val configuration: JobConfigurationResponse? = null,
    public val environmentId: String? = null,
    public val eventStreamEndpoint: String,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val outboundIpAddresses: List<String>,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val template: JobTemplateResponse? = null,
    public val type: String,
    public val workloadProfileName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GetJobResult): GetJobResult =
            GetJobResult(
                configuration = javaType.configuration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.JobConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                environmentId = javaType.environmentId().map({ args0 -> args0 }).orElse(null),
                eventStreamEndpoint = javaType.eventStreamEndpoint(),
                id = javaType.id(),
                identity = javaType.identity().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                location = javaType.location(),
                name = javaType.name(),
                outboundIpAddresses = javaType.outboundIpAddresses().map({ args0 -> args0 }),
                provisioningState = javaType.provisioningState(),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                template = javaType.template().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.app.kotlin.outputs.JobTemplateResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                type = javaType.type(),
                workloadProfileName = javaType.workloadProfileName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
