@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An environment for hosting container apps
 * @property appLogsConfiguration Cluster configuration which enables the log daemon to export
 * app logs to a destination. Currently only "log-analytics" is
 * supported
 * @property customDomainConfiguration Custom domain configuration for the environment
 * @property daprAIConnectionString Application Insights connection string used by Dapr to export Service to Service communication telemetry
 * @property daprAIInstrumentationKey Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
 * @property defaultDomain Default Domain Name for the cluster
 * @property deploymentErrors Any errors that occurred during deployment or deployment validation
 * @property eventStreamEndpoint The endpoint of the eventstream of the Environment.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind Kind of the Environment.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the Environment.
 * @property sku SKU properties of the Environment.
 * @property staticIp Static IP of the Environment
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vnetConfiguration Vnet configuration for the environment
 * @property workloadProfiles Workload profiles configured for the Managed Environment.
 * @property zoneRedundant Whether or not this Managed Environment is zone-redundant.
 */
public data class GetManagedEnvironmentResult(
    public val appLogsConfiguration: AppLogsConfigurationResponse? = null,
    public val customDomainConfiguration: CustomDomainConfigurationResponse? = null,
    public val daprAIConnectionString: String? = null,
    public val daprAIInstrumentationKey: String? = null,
    public val defaultDomain: String,
    public val deploymentErrors: String,
    public val eventStreamEndpoint: String,
    public val id: String,
    public val kind: String? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val sku: EnvironmentSkuPropertiesResponse? = null,
    public val staticIp: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vnetConfiguration: VnetConfigurationResponse? = null,
    public val workloadProfiles: List<WorkloadProfileResponse>? = null,
    public val zoneRedundant: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.GetManagedEnvironmentResult):
            GetManagedEnvironmentResult = GetManagedEnvironmentResult(
            appLogsConfiguration = javaType.appLogsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.AppLogsConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customDomainConfiguration = javaType.customDomainConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.CustomDomainConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            daprAIConnectionString = javaType.daprAIConnectionString().map({ args0 -> args0 }).orElse(null),
            daprAIInstrumentationKey = javaType.daprAIInstrumentationKey().map({ args0 -> args0 }).orElse(null),
            defaultDomain = javaType.defaultDomain(),
            deploymentErrors = javaType.deploymentErrors(),
            eventStreamEndpoint = javaType.eventStreamEndpoint(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.EnvironmentSkuPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            staticIp = javaType.staticIp(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vnetConfiguration = javaType.vnetConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.VnetConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workloadProfiles = javaType.workloadProfiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.WorkloadProfileResponse.Companion.toKotlin(args0)
                })
            }),
            zoneRedundant = javaType.zoneRedundant().map({ args0 -> args0 }).orElse(null),
        )
    }
}
