@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration properties for a Java Component
 * @property propertyName The name of the property
 * @property value The value of the property
 */
public data class JavaComponentConfigurationPropertyResponse(
    public val propertyName: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.JavaComponentConfigurationPropertyResponse):
            JavaComponentConfigurationPropertyResponse = JavaComponentConfigurationPropertyResponse(
            propertyName = javaType.propertyName().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
