@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Log Analytics configuration, must only be provided when destination is configured as 'log-analytics'
 * @property customerId Log analytics customer id
 */
public data class LogAnalyticsConfigurationResponse(
    public val customerId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.LogAnalyticsConfigurationResponse):
            LogAnalyticsConfigurationResponse = LogAnalyticsConfigurationResponse(
            customerId = javaType.customerId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
