@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Certificate resource specific properties
 * @property domainControlValidation Selected type of domain control validation for managed certificates.
 * @property error Any error occurred during the certificate provision.
 * @property provisioningState Provisioning state of the certificate.
 * @property subjectName Subject name of the certificate.
 * @property validationToken A TXT token used for DNS TXT domain control validation when issuing this type of managed certificates.
 */
public data class ManagedCertificateResponseProperties(
    public val domainControlValidation: String? = null,
    public val error: String,
    public val provisioningState: String,
    public val subjectName: String? = null,
    public val validationToken: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.ManagedCertificateResponseProperties):
            ManagedCertificateResponseProperties = ManagedCertificateResponseProperties(
            domainControlValidation = javaType.domainControlValidation().map({ args0 -> args0 }).orElse(null),
            error = javaType.error(),
            provisioningState = javaType.provisioningState(),
            subjectName = javaType.subjectName().map({ args0 -> args0 }).orElse(null),
            validationToken = javaType.validationToken(),
        )
    }
}
