@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The configuration settings of the nonce used in the login flow.
 * @property nonceExpirationInterval The time after the request is made when the nonce should expire.
 * @property validateNonce <code>false</code> if the nonce should not be validated while completing the login flow; otherwise, <code>true</code>.
 */
public data class NonceResponse(
    public val nonceExpirationInterval: String? = null,
    public val validateNonce: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.NonceResponse): NonceResponse =
            NonceResponse(
                nonceExpirationInterval = javaType.nonceExpirationInterval().map({ args0 -> args0 }).orElse(null),
                validateNonce = javaType.validateNonce().map({ args0 -> args0 }).orElse(null),
            )
    }
}
