@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The authentication client credentials of the custom Open ID Connect provider.
 * @property clientSecretSettingName The app setting that contains the client secret for the custom Open ID Connect provider.
 * @property method The method that should be used to authenticate the user.
 */
public data class OpenIdConnectClientCredentialResponse(
    public val clientSecretSettingName: String? = null,
    public val method: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.OpenIdConnectClientCredentialResponse):
            OpenIdConnectClientCredentialResponse = OpenIdConnectClientCredentialResponse(
            clientSecretSettingName = javaType.clientSecretSettingName().map({ args0 -> args0 }).orElse(null),
            method = javaType.method().map({ args0 -> args0 }).orElse(null),
        )
    }
}
