@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Secret definition.
 * @property identity Resource ID of a managed identity to authenticate with Azure Key Vault, or System to use a system-assigned identity.
 * @property keyVaultUrl Azure Key Vault URL pointing to the secret referenced by the container app.
 * @property name Secret Name.
 */
public data class SecretResponse(
    public val identity: String? = null,
    public val keyVaultUrl: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.SecretResponse): SecretResponse =
            SecretResponse(
                identity = javaType.identity().map({ args0 -> args0 }).orElse(null),
                keyVaultUrl = javaType.keyVaultUrl().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
            )
    }
}
