@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Secret to be added to volume.
 * @property path Path to project secret to. If no path is provided, path defaults to name of secret listed in secretRef.
 * @property secretRef Name of the Container App secret from which to pull the secret value.
 */
public data class SecretVolumeItemResponse(
    public val path: String? = null,
    public val secretRef: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.SecretVolumeItemResponse):
            SecretVolumeItemResponse = SecretVolumeItemResponse(
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            secretRef = javaType.secretRef().map({ args0 -> args0 }).orElse(null),
        )
    }
}
