@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Volume mount for the Container App.
 * @property mountPath Path within the container at which the volume should be mounted.Must not contain ':'.
 * @property subPath Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
 * @property volumeName This must match the Name of a Volume.
 */
public data class VolumeMountResponse(
    public val mountPath: String? = null,
    public val subPath: String? = null,
    public val volumeName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.VolumeMountResponse):
            VolumeMountResponse = VolumeMountResponse(
            mountPath = javaType.mountPath().map({ args0 -> args0 }).orElse(null),
            subPath = javaType.subPath().map({ args0 -> args0 }).orElse(null),
            volumeName = javaType.volumeName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
