@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin

import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.ReportPropertiesResponse
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.ReportPropertiesResponse.Companion.toKotlin as reportPropertiesResponseToKotlin
import com.pulumi.azurenative.appcomplianceautomation.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Report].
 */
@PulumiTagMarker
public class ReportResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReportArgs = ReportArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReportArgsBuilder.() -> Unit) {
        val builder = ReportArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Report {
        val builtJavaResource =
            com.pulumi.azurenative.appcomplianceautomation.Report(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Report(builtJavaResource)
    }
}

/**
 * A class represent an AppComplianceAutomation report resource.
 * Azure REST API version: 2022-11-16-preview. Prior API version in Azure Native 1.x: 2022-11-16-preview.
 * ## Example Usage
 * ### Report_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var report = new AzureNative.AppComplianceAutomation.Report("report", new()
 *     {
 *         Properties = new AzureNative.AppComplianceAutomation.Inputs.ReportPropertiesArgs
 *         {
 *             OfferGuid = "0000",
 *             Resources = new[]
 *             {
 *                 new AzureNative.AppComplianceAutomation.Inputs.ResourceMetadataArgs
 *                 {
 *                     ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint",
 *                     Tags =
 *                     {
 *                         { "key1", "value1" },
 *                     },
 *                 },
 *             },
 *             TimeZone = "GMT Standard Time",
 *             TriggerTime = "2022-03-04T05:11:56.197Z",
 *         },
 *         ReportName = "testReportName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appcomplianceautomation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appcomplianceautomation.NewReport(ctx, "report", &appcomplianceautomation.ReportArgs{
 * 			Properties: appcomplianceautomation.ReportPropertiesResponse{
 * 				OfferGuid: pulumi.String("0000"),
 * 				Resources: appcomplianceautomation.ResourceMetadataArray{
 * 					&appcomplianceautomation.ResourceMetadataArgs{
 * 						ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
 * 						Tags: pulumi.StringMap{
 * 							"key1": pulumi.String("value1"),
 * 						},
 * 					},
 * 				},
 * 				TimeZone:    pulumi.String("GMT Standard Time"),
 * 				TriggerTime: pulumi.String("2022-03-04T05:11:56.197Z"),
 * 			},
 * 			ReportName: pulumi.String("testReportName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appcomplianceautomation.Report;
 * import com.pulumi.azurenative.appcomplianceautomation.ReportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var report = new Report("report", ReportArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("offerGuid", "0000"),
 *                 Map.entry("resources", Map.ofEntries(
 *                     Map.entry("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
 *                     Map.entry("tags", Map.of("key1", "value1"))
 *                 )),
 *                 Map.entry("timeZone", "GMT Standard Time"),
 *                 Map.entry("triggerTime", "2022-03-04T05:11:56.197Z")
 *             ))
 *             .reportName("testReportName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appcomplianceautomation:Report testReportName /providers/Microsoft.AppComplianceAutomation/reports/{reportName}
 * ```
 */
public class Report internal constructor(
    override val javaResource: com.pulumi.azurenative.appcomplianceautomation.Report,
) : KotlinCustomResource(javaResource, ReportMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Report property.
     */
    public val properties: Output<ReportPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                reportPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReportMapper : ResourceMapper<Report> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appcomplianceautomation.Report::class == javaResource::class

    override fun map(javaResource: Resource): Report = Report(
        javaResource as
            com.pulumi.azurenative.appcomplianceautomation.Report,
    )
}

/**
 * @see [Report].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Report].
 */
public suspend fun report(name: String, block: suspend ReportResourceBuilder.() -> Unit): Report {
    val builder = ReportResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Report].
 * @param name The _unique_ name of the resulting resource.
 */
public fun report(name: String): Report {
    val builder = ReportResourceBuilder()
    builder.name(name)
    return builder.build()
}
