@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appcomplianceautomation.kotlin

import com.pulumi.azurenative.appcomplianceautomation.ReportArgs.builder
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.ReportPropertiesArgs
import com.pulumi.azurenative.appcomplianceautomation.kotlin.inputs.ReportPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A class represent an AppComplianceAutomation report resource.
 * Azure REST API version: 2022-11-16-preview. Prior API version in Azure Native 1.x: 2022-11-16-preview.
 * ## Example Usage
 * ### Report_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var report = new AzureNative.AppComplianceAutomation.Report("report", new()
 *     {
 *         Properties = new AzureNative.AppComplianceAutomation.Inputs.ReportPropertiesArgs
 *         {
 *             OfferGuid = "0000",
 *             Resources = new[]
 *             {
 *                 new AzureNative.AppComplianceAutomation.Inputs.ResourceMetadataArgs
 *                 {
 *                     ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint",
 *                     Tags =
 *                     {
 *                         { "key1", "value1" },
 *                     },
 *                 },
 *             },
 *             TimeZone = "GMT Standard Time",
 *             TriggerTime = "2022-03-04T05:11:56.197Z",
 *         },
 *         ReportName = "testReportName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appcomplianceautomation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appcomplianceautomation.NewReport(ctx, "report", &appcomplianceautomation.ReportArgs{
 * 			Properties: appcomplianceautomation.ReportPropertiesResponse{
 * 				OfferGuid: pulumi.String("0000"),
 * 				Resources: appcomplianceautomation.ResourceMetadataArray{
 * 					&appcomplianceautomation.ResourceMetadataArgs{
 * 						ResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
 * 						Tags: pulumi.StringMap{
 * 							"key1": pulumi.String("value1"),
 * 						},
 * 					},
 * 				},
 * 				TimeZone:    pulumi.String("GMT Standard Time"),
 * 				TriggerTime: pulumi.String("2022-03-04T05:11:56.197Z"),
 * 			},
 * 			ReportName: pulumi.String("testReportName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appcomplianceautomation.Report;
 * import com.pulumi.azurenative.appcomplianceautomation.ReportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var report = new Report("report", ReportArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("offerGuid", "0000"),
 *                 Map.entry("resources", Map.ofEntries(
 *                     Map.entry("resourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint"),
 *                     Map.entry("tags", Map.of("key1", "value1"))
 *                 )),
 *                 Map.entry("timeZone", "GMT Standard Time"),
 *                 Map.entry("triggerTime", "2022-03-04T05:11:56.197Z")
 *             ))
 *             .reportName("testReportName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appcomplianceautomation:Report testReportName /providers/Microsoft.AppComplianceAutomation/reports/{reportName}
 * ```
 * @property properties Report property.
 * @property reportName Report Name.
 */
public data class ReportArgs(
    public val properties: Output<ReportPropertiesArgs>? = null,
    public val reportName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appcomplianceautomation.ReportArgs> {
    override fun toJava(): com.pulumi.azurenative.appcomplianceautomation.ReportArgs =
        com.pulumi.azurenative.appcomplianceautomation.ReportArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .reportName(reportName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportArgs].
 */
@PulumiTagMarker
public class ReportArgsBuilder internal constructor() {
    private var properties: Output<ReportPropertiesArgs>? = null

    private var reportName: Output<String>? = null

    /**
     * @param value Report property.
     */
    @JvmName("oknadhsleqelpigo")
    public suspend fun properties(`value`: Output<ReportPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Report Name.
     */
    @JvmName("bxvwpyeaxwqgoqal")
    public suspend fun reportName(`value`: Output<String>) {
        this.reportName = value
    }

    /**
     * @param value Report property.
     */
    @JvmName("hhhwjxccjbaxetse")
    public suspend fun properties(`value`: ReportPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Report property.
     */
    @JvmName("onsnhwkdqrfoqdpt")
    public suspend fun properties(argument: suspend ReportPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ReportPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Report Name.
     */
    @JvmName("lmqfewdpqorjyxes")
    public suspend fun reportName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportName = mapped
    }

    internal fun build(): ReportArgs = ReportArgs(
        properties = properties,
        reportName = reportName,
    )
}
