@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [KeyValue].
 */
@PulumiTagMarker
public class KeyValueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyValueArgs = KeyValueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyValueArgsBuilder.() -> Unit) {
        val builder = KeyValueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KeyValue {
        val builtJavaResource =
            com.pulumi.azurenative.appconfiguration.KeyValue(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return KeyValue(builtJavaResource)
    }
}

/**
 * The key-value resource along with all resource properties.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-07-01-preview.
 * Other available API versions: 2023-08-01-preview.
 * ## Example Usage
 * ### KeyValues_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var keyValue = new AzureNative.AppConfiguration.KeyValue("keyValue", new()
 *     {
 *         ConfigStoreName = "contoso",
 *         KeyValueName = "myKey$myLabel",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "tag1", "tagValue1" },
 *             { "tag2", "tagValue2" },
 *         },
 *         Value = "myValue",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appconfiguration.NewKeyValue(ctx, "keyValue", &appconfiguration.KeyValueArgs{
 * 			ConfigStoreName:   pulumi.String("contoso"),
 * 			KeyValueName:      pulumi.String("myKey$myLabel"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("tagValue1"),
 * 				"tag2": pulumi.String("tagValue2"),
 * 			},
 * 			Value: pulumi.String("myValue"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appconfiguration.KeyValue;
 * import com.pulumi.azurenative.appconfiguration.KeyValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var keyValue = new KeyValue("keyValue", KeyValueArgs.builder()
 *             .configStoreName("contoso")
 *             .keyValueName("myKey$myLabel")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "tagValue1"),
 *                 Map.entry("tag2", "tagValue2")
 *             ))
 *             .value("myValue")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appconfiguration:KeyValue myKey$myLabel /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}/keyValues/{keyValueName}
 * ```
 */
public class KeyValue internal constructor(
    override val javaResource: com.pulumi.azurenative.appconfiguration.KeyValue,
) : KotlinCustomResource(javaResource, KeyValueMapper) {
    /**
     * The content type of the key-value's value.
     * Providing a proper content-type can enable transformations of values when they are retrieved by applications.
     */
    public val contentType: Output<String>?
        get() = javaResource.contentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An ETag indicating the state of a key-value within a configuration store.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * The primary identifier of a key-value.
     * The key is used in unison with the label to uniquely identify a key-value.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * A value used to group key-values.
     * The label is used in unison with the key to uniquely identify a key-value.
     */
    public val label: Output<String>
        get() = javaResource.label().applyValue({ args0 -> args0 })

    /**
     * The last time a modifying operation was performed on the given key-value.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * A value indicating whether the key-value is locked.
     * A locked key-value may not be modified until it is unlocked.
     */
    public val locked: Output<Boolean>
        get() = javaResource.locked().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A dictionary of tags that can help identify what a key-value may be applicable for.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The value of the key-value.
     */
    public val `value`: Output<String>?
        get() = javaResource.`value`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object KeyValueMapper : ResourceMapper<KeyValue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appconfiguration.KeyValue::class == javaResource::class

    override fun map(javaResource: Resource): KeyValue = KeyValue(
        javaResource as
            com.pulumi.azurenative.appconfiguration.KeyValue,
    )
}

/**
 * @see [KeyValue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyValue].
 */
public suspend fun keyValue(name: String, block: suspend KeyValueResourceBuilder.() -> Unit):
    KeyValue {
    val builder = KeyValueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyValue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyValue(name: String): KeyValue {
    val builder = KeyValueResourceBuilder()
    builder.name(name)
    return builder.build()
}
