@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.inputs

import com.pulumi.azurenative.appconfiguration.inputs.KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings concerning key vault encryption for a configuration store.
 * @property identityClientId The client id of the identity which will be used to access key vault.
 * @property keyIdentifier The URI of the key vault key used to encrypt data.
 */
public data class KeyVaultPropertiesArgs(
    public val identityClientId: Output<String>? = null,
    public val keyIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appconfiguration.inputs.KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appconfiguration.inputs.KeyVaultPropertiesArgs =
        com.pulumi.azurenative.appconfiguration.inputs.KeyVaultPropertiesArgs.builder()
            .identityClientId(identityClientId?.applyValue({ args0 -> args0 }))
            .keyIdentifier(keyIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultPropertiesArgsBuilder internal constructor() {
    private var identityClientId: Output<String>? = null

    private var keyIdentifier: Output<String>? = null

    /**
     * @param value The client id of the identity which will be used to access key vault.
     */
    @JvmName("gstynouownscyceu")
    public suspend fun identityClientId(`value`: Output<String>) {
        this.identityClientId = value
    }

    /**
     * @param value The URI of the key vault key used to encrypt data.
     */
    @JvmName("jaeobybglobbekfi")
    public suspend fun keyIdentifier(`value`: Output<String>) {
        this.keyIdentifier = value
    }

    /**
     * @param value The client id of the identity which will be used to access key vault.
     */
    @JvmName("hrcbtllmkeylowif")
    public suspend fun identityClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityClientId = mapped
    }

    /**
     * @param value The URI of the key vault key used to encrypt data.
     */
    @JvmName("mxpmgeqkpdnhwtmv")
    public suspend fun keyIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyIdentifier = mapped
    }

    internal fun build(): KeyVaultPropertiesArgs = KeyVaultPropertiesArgs(
        identityClientId = identityClientId,
        keyIdentifier = keyIdentifier,
    )
}
