@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.inputs

import com.pulumi.azurenative.appconfiguration.inputs.ListConfigurationStoreKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configStoreName The name of the configuration store.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 * @property skipToken A skip token is used to continue retrieving items after an operation returns a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies a starting point to use for subsequent calls.
 */
public data class ListConfigurationStoreKeysPlainArgs(
    public val configStoreName: String,
    public val resourceGroupName: String,
    public val skipToken: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.appconfiguration.inputs.ListConfigurationStoreKeysPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.appconfiguration.inputs.ListConfigurationStoreKeysPlainArgs =
        com.pulumi.azurenative.appconfiguration.inputs.ListConfigurationStoreKeysPlainArgs.builder()
            .configStoreName(configStoreName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListConfigurationStoreKeysPlainArgs].
 */
@PulumiTagMarker
public class ListConfigurationStoreKeysPlainArgsBuilder internal constructor() {
    private var configStoreName: String? = null

    private var resourceGroupName: String? = null

    private var skipToken: String? = null

    /**
     * @param value The name of the configuration store.
     */
    @JvmName("hjmxiafeoxwvfqho")
    public suspend fun configStoreName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configStoreName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("crmjcwncvpgygjwa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value A skip token is used to continue retrieving items after an operation returns a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies a starting point to use for subsequent calls.
     */
    @JvmName("hqrwcvmidvjyopdc")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    internal fun build(): ListConfigurationStoreKeysPlainArgs = ListConfigurationStoreKeysPlainArgs(
        configStoreName = configStoreName ?: throw PulumiNullFieldException("configStoreName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        skipToken = skipToken,
    )
}
