@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The configuration store along with all resource properties. The Configuration Store will have all information to begin utilizing it.
 * @property creationDate The creation date of configuration store.
 * @property disableLocalAuth Disables all authentication methods other than AAD authentication.
 * @property enablePurgeProtection Property specifying whether protection against purge is enabled for this configuration store.
 * @property encryption The encryption settings of the configuration store.
 * @property endpoint The DNS endpoint where the configuration store API will be available.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The managed identity information, if configured.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property privateEndpointConnections The list of private endpoint connections that are set up for this resource.
 * @property provisioningState The provisioning state of the configuration store.
 * @property publicNetworkAccess Control permission for data plane traffic coming from public networks while private endpoint is enabled.
 * @property sku The sku of the configuration store.
 * @property softDeleteRetentionInDays The amount of time in days that the configuration store will be retained when it is soft deleted.
 * @property systemData Resource system metadata.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetConfigurationStoreResult(
    public val creationDate: String,
    public val disableLocalAuth: Boolean? = null,
    public val enablePurgeProtection: Boolean? = null,
    public val encryption: EncryptionPropertiesResponse? = null,
    public val endpoint: String,
    public val id: String,
    public val identity: ResourceIdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionReferenceResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val sku: SkuResponse,
    public val softDeleteRetentionInDays: Int? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appconfiguration.outputs.GetConfigurationStoreResult):
            GetConfigurationStoreResult = GetConfigurationStoreResult(
            creationDate = javaType.creationDate(),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            enablePurgeProtection = javaType.enablePurgeProtection().map({ args0 -> args0 }).orElse(null),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appconfiguration.kotlin.outputs.EncryptionPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endpoint = javaType.endpoint(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appconfiguration.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appconfiguration.kotlin.outputs.PrivateEndpointConnectionReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.appconfiguration.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            softDeleteRetentionInDays = javaType.softDeleteRetentionInDays().map({ args0 ->
                args0
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.appconfiguration.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
