@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The key-value resource along with all resource properties.
 * @property contentType The content type of the key-value's value.
 * Providing a proper content-type can enable transformations of values when they are retrieved by applications.
 * @property eTag An ETag indicating the state of a key-value within a configuration store.
 * @property id The resource ID.
 * @property key The primary identifier of a key-value.
 * The key is used in unison with the label to uniquely identify a key-value.
 * @property label A value used to group key-values.
 * The label is used in unison with the key to uniquely identify a key-value.
 * @property lastModified The last time a modifying operation was performed on the given key-value.
 * @property locked A value indicating whether the key-value is locked.
 * A locked key-value may not be modified until it is unlocked.
 * @property name The name of the resource.
 * @property tags A dictionary of tags that can help identify what a key-value may be applicable for.
 * @property type The type of the resource.
 * @property value The value of the key-value.
 */
public data class GetKeyValueResult(
    public val contentType: String? = null,
    public val eTag: String,
    public val id: String,
    public val key: String,
    public val label: String,
    public val lastModified: String,
    public val locked: Boolean,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appconfiguration.outputs.GetKeyValueResult):
            GetKeyValueResult = GetKeyValueResult(
            contentType = javaType.contentType().map({ args0 -> args0 }).orElse(null),
            eTag = javaType.eTag(),
            id = javaType.id(),
            key = javaType.key(),
            label = javaType.label(),
            lastModified = javaType.lastModified(),
            locked = javaType.locked(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
