@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The result of a request to list API keys.
 * @property nextLink The URI that can be used to request the next set of paged results.
 * @property value The collection value.
 */
public data class ListConfigurationStoreKeysResult(
    public val nextLink: String? = null,
    public val `value`: List<ApiKeyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appconfiguration.outputs.ListConfigurationStoreKeysResult):
            ListConfigurationStoreKeysResult = ListConfigurationStoreKeysResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appconfiguration.kotlin.outputs.ApiKeyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
