@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.AppResourcePropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.ManagedIdentityPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.AppResourcePropertiesResponse.Companion.toKotlin as appResourcePropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.ManagedIdentityPropertiesResponse.Companion.toKotlin as managedIdentityPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [App].
 */
@PulumiTagMarker
public class AppResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppArgs = AppArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppArgsBuilder.() -> Unit) {
        val builder = AppArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): App {
        val builtJavaResource = com.pulumi.azurenative.appplatform.App(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return App(builtJavaResource)
    }
}

/**
 * App resource payload
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:App myapp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}
 * ```
 */
public class App internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.App,
) : KotlinCustomResource(javaResource, AppMapper) {
    /**
     * The Managed Identity type of the app resource
     */
    public val identity: Output<ManagedIdentityPropertiesResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedIdentityPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The GEO location of the application, always the same with its parent resource
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the App resource
     */
    public val properties: Output<AppResourcePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                appResourcePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AppMapper : ResourceMapper<App> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.App::class == javaResource::class

    override fun map(javaResource: Resource): App = App(
        javaResource as
            com.pulumi.azurenative.appplatform.App,
    )
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [App].
 */
public suspend fun app(name: String, block: suspend AppResourceBuilder.() -> Unit): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 */
public fun app(name: String): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    return builder.build()
}
