@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.AppArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.AppResourcePropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.AppResourcePropertiesArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.ManagedIdentityPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.ManagedIdentityPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * App resource payload
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:App myapp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}
 * ```
 * @property appName The name of the App resource.
 * @property identity The Managed Identity type of the app resource
 * @property location The GEO location of the application, always the same with its parent resource
 * @property properties Properties of the App resource
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class AppArgs(
    public val appName: Output<String>? = null,
    public val identity: Output<ManagedIdentityPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<AppResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.AppArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.AppArgs =
        com.pulumi.azurenative.appplatform.AppArgs.builder()
            .appName(appName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppArgs].
 */
@PulumiTagMarker
public class AppArgsBuilder internal constructor() {
    private var appName: Output<String>? = null

    private var identity: Output<ManagedIdentityPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<AppResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of the App resource.
     */
    @JvmName("raqlwwmqspitgbhp")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value The Managed Identity type of the app resource
     */
    @JvmName("pbhojhwnuhjvhtyt")
    public suspend fun identity(`value`: Output<ManagedIdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value The GEO location of the application, always the same with its parent resource
     */
    @JvmName("grjtisftqxeffxwg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of the App resource
     */
    @JvmName("laqnkxlimxlhncum")
    public suspend fun properties(`value`: Output<AppResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("uefnbixtqsflljwd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("fytfgqnehyisqfqf")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the App resource.
     */
    @JvmName("otofnxmbbnvpwoph")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value The Managed Identity type of the app resource
     */
    @JvmName("aywnvvpkxxjthyuu")
    public suspend fun identity(`value`: ManagedIdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The Managed Identity type of the app resource
     */
    @JvmName("snydkbcebemeimgl")
    public suspend fun identity(argument: suspend ManagedIdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The GEO location of the application, always the same with its parent resource
     */
    @JvmName("yyblakpgeuespoxs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of the App resource
     */
    @JvmName("keltqaerpbcvqecm")
    public suspend fun properties(`value`: AppResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the App resource
     */
    @JvmName("vtugdsfycanskthr")
    public suspend fun properties(argument: suspend AppResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AppResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("koggnmgeuiqbkhnv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("kxmndmsjgitboqud")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): AppArgs = AppArgs(
        appName = appName,
        identity = identity,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
