@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.BuildServiceAgentPoolArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.BuildServiceAgentPoolPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.BuildServiceAgentPoolPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The build service agent pool resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### BuildServiceAgentPool_UpdatePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var buildServiceAgentPool = new AzureNative.AppPlatform.BuildServiceAgentPool("buildServiceAgentPool", new()
 *     {
 *         AgentPoolName = "default",
 *         BuildServiceName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.BuildServiceAgentPoolPropertiesArgs
 *         {
 *             PoolSize = new AzureNative.AppPlatform.Inputs.BuildServiceAgentPoolSizePropertiesArgs
 *             {
 *                 Name = "S3",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewBuildServiceAgentPool(ctx, "buildServiceAgentPool", &appplatform.BuildServiceAgentPoolArgs{
 * 			AgentPoolName:    pulumi.String("default"),
 * 			BuildServiceName: pulumi.String("default"),
 * 			Properties: appplatform.BuildServiceAgentPoolPropertiesResponse{
 * 				PoolSize: &appplatform.BuildServiceAgentPoolSizePropertiesArgs{
 * 					Name: pulumi.String("S3"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.BuildServiceAgentPool;
 * import com.pulumi.azurenative.appplatform.BuildServiceAgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var buildServiceAgentPool = new BuildServiceAgentPool("buildServiceAgentPool", BuildServiceAgentPoolArgs.builder()
 *             .agentPoolName("default")
 *             .buildServiceName("default")
 *             .properties(Map.of("poolSize", Map.of("name", "S3")))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:BuildServiceAgentPool default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/agentPools/{agentPoolName}
 * ```
 * @property agentPoolName The name of the build service agent pool resource.
 * @property buildServiceName The name of the build service resource.
 * @property properties build service agent pool properties
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class BuildServiceAgentPoolArgs(
    public val agentPoolName: Output<String>? = null,
    public val buildServiceName: Output<String>? = null,
    public val properties: Output<BuildServiceAgentPoolPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.BuildServiceAgentPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.BuildServiceAgentPoolArgs =
        com.pulumi.azurenative.appplatform.BuildServiceAgentPoolArgs.builder()
            .agentPoolName(agentPoolName?.applyValue({ args0 -> args0 }))
            .buildServiceName(buildServiceName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BuildServiceAgentPoolArgs].
 */
@PulumiTagMarker
public class BuildServiceAgentPoolArgsBuilder internal constructor() {
    private var agentPoolName: Output<String>? = null

    private var buildServiceName: Output<String>? = null

    private var properties: Output<BuildServiceAgentPoolPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of the build service agent pool resource.
     */
    @JvmName("xnsrfblgoseycawk")
    public suspend fun agentPoolName(`value`: Output<String>) {
        this.agentPoolName = value
    }

    /**
     * @param value The name of the build service resource.
     */
    @JvmName("acsdaffdoeqpgpsg")
    public suspend fun buildServiceName(`value`: Output<String>) {
        this.buildServiceName = value
    }

    /**
     * @param value build service agent pool properties
     */
    @JvmName("iayihiqaeielqhgy")
    public suspend fun properties(`value`: Output<BuildServiceAgentPoolPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("fmoyborfcfwpphpw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("ituiaywxrhcgupae")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the build service agent pool resource.
     */
    @JvmName("mgeuxuxvkgtbuiko")
    public suspend fun agentPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolName = mapped
    }

    /**
     * @param value The name of the build service resource.
     */
    @JvmName("oaiwrpqhovnoojve")
    public suspend fun buildServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildServiceName = mapped
    }

    /**
     * @param value build service agent pool properties
     */
    @JvmName("esiqbjwradtstybp")
    public suspend fun properties(`value`: BuildServiceAgentPoolPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument build service agent pool properties
     */
    @JvmName("lobgyxybrurvpken")
    public suspend
    fun properties(argument: suspend BuildServiceAgentPoolPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BuildServiceAgentPoolPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("nmgnkkvbdmdlbtft")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("odtniyekargrdgvl")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): BuildServiceAgentPoolArgs = BuildServiceAgentPoolArgs(
        agentPoolName = agentPoolName,
        buildServiceName = buildServiceName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
