@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.CertificateArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.ContentCertificatePropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.KeyVaultCertificatePropertiesArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Certificate resource payload.
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2021-06-01-preview, 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### Certificates_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificate = new AzureNative.AppPlatform.Certificate("certificate", new()
 *     {
 *         CertificateName = "mycertificate",
 *         Properties = new AzureNative.AppPlatform.Inputs.KeyVaultCertificatePropertiesArgs
 *         {
 *             CertVersion = "08a219d06d874795a96db47e06fbb01e",
 *             KeyVaultCertName = "mycert",
 *             Type = "KeyVaultCertificate",
 *             VaultUri = "https://myvault.vault.azure.net",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewCertificate(ctx, "certificate", &appplatform.CertificateArgs{
 * 			CertificateName: pulumi.String("mycertificate"),
 * 			Properties: appplatform.KeyVaultCertificateProperties{
 * 				CertVersion:      "08a219d06d874795a96db47e06fbb01e",
 * 				KeyVaultCertName: "mycert",
 * 				Type:             "KeyVaultCertificate",
 * 				VaultUri:         "https://myvault.vault.azure.net",
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Certificate;
 * import com.pulumi.azurenative.appplatform.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificate = new Certificate("certificate", CertificateArgs.builder()
 *             .certificateName("mycertificate")
 *             .properties(Map.ofEntries(
 *                 Map.entry("certVersion", "08a219d06d874795a96db47e06fbb01e"),
 *                 Map.entry("keyVaultCertName", "mycert"),
 *                 Map.entry("type", "KeyVaultCertificate"),
 *                 Map.entry("vaultUri", "https://myvault.vault.azure.net")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Certificate mycertificate /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/certificates/{certificateName}
 * ```
 * @property certificateName The name of the certificate resource.
 * @property properties Properties of the certificate resource payload.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class CertificateArgs(
    public val certificateName: Output<String>? = null,
    public val properties:
    Output<Either<ContentCertificatePropertiesArgs, KeyVaultCertificatePropertiesArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.CertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.CertificateArgs =
        com.pulumi.azurenative.appplatform.CertificateArgs.builder()
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
public class CertificateArgsBuilder internal constructor() {
    private var certificateName: Output<String>? = null

    private var properties:
        Output<Either<ContentCertificatePropertiesArgs, KeyVaultCertificatePropertiesArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of the certificate resource.
     */
    @JvmName("kvflmqykgxolhaer")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value Properties of the certificate resource payload.
     */
    @JvmName("fkruljumptpdqmaw")
    public suspend
    fun properties(`value`: Output<Either<ContentCertificatePropertiesArgs, KeyVaultCertificatePropertiesArgs>>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ifndxncktpuhwiho")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("ywqojdeocbvgrhsa")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the certificate resource.
     */
    @JvmName("pugofweubjsmsexl")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value Properties of the certificate resource payload.
     */
    @JvmName("lmplifjrtqhoncnv")
    public suspend
    fun properties(`value`: Either<ContentCertificatePropertiesArgs, KeyVaultCertificatePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Properties of the certificate resource payload.
     */
    @JvmName("ksqmbwfhedbcrrlh")
    public fun properties(`value`: ContentCertificatePropertiesArgs) {
        val toBeMapped = Either.ofLeft<ContentCertificatePropertiesArgs,
            KeyVaultCertificatePropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Properties of the certificate resource payload.
     */
    @JvmName("ilmgfflaohspqnfa")
    public fun properties(`value`: KeyVaultCertificatePropertiesArgs) {
        val toBeMapped = Either.ofRight<ContentCertificatePropertiesArgs,
            KeyVaultCertificatePropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("lohuwsaytsandoaa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("ccgqtvmlnlkycfem")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        certificateName = certificateName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
