@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.CustomDomainArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.CustomDomainPropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.CustomDomainPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Custom domain resource payload.
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CustomDomains_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customDomain = new AzureNative.AppPlatform.CustomDomain("customDomain", new()
 *     {
 *         AppName = "myapp",
 *         DomainName = "mydomain.com",
 *         Properties = new AzureNative.AppPlatform.Inputs.CustomDomainPropertiesArgs
 *         {
 *             CertName = "mycert",
 *             Thumbprint = "934367bf1c97033f877db0f15cb1b586957d3133",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewCustomDomain(ctx, "customDomain", &appplatform.CustomDomainArgs{
 * 			AppName:    pulumi.String("myapp"),
 * 			DomainName: pulumi.String("mydomain.com"),
 * 			Properties: &appplatform.CustomDomainPropertiesArgs{
 * 				CertName:   pulumi.String("mycert"),
 * 				Thumbprint: pulumi.String("934367bf1c97033f877db0f15cb1b586957d3133"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.CustomDomain;
 * import com.pulumi.azurenative.appplatform.CustomDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customDomain = new CustomDomain("customDomain", CustomDomainArgs.builder()
 *             .appName("myapp")
 *             .domainName("mydomain.com")
 *             .properties(Map.ofEntries(
 *                 Map.entry("certName", "mycert"),
 *                 Map.entry("thumbprint", "934367bf1c97033f877db0f15cb1b586957d3133")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:CustomDomain mydomain.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/apps/{appName}/domains/{domainName}
 * ```
 * @property appName The name of the App resource.
 * @property domainName The name of the custom domain resource.
 * @property properties Properties of the custom domain resource.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class CustomDomainArgs(
    public val appName: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val properties: Output<CustomDomainPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.CustomDomainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.CustomDomainArgs =
        com.pulumi.azurenative.appplatform.CustomDomainArgs.builder()
            .appName(appName?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomDomainArgs].
 */
@PulumiTagMarker
public class CustomDomainArgsBuilder internal constructor() {
    private var appName: Output<String>? = null

    private var domainName: Output<String>? = null

    private var properties: Output<CustomDomainPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The name of the App resource.
     */
    @JvmName("kmxieqielerwxcho")
    public suspend fun appName(`value`: Output<String>) {
        this.appName = value
    }

    /**
     * @param value The name of the custom domain resource.
     */
    @JvmName("mclffdnkknplfhol")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Properties of the custom domain resource.
     */
    @JvmName("pviycbmbltjiryqs")
    public suspend fun properties(`value`: Output<CustomDomainPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qeoitxkblvfuqfgq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("alggfagsadbwfwjv")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the App resource.
     */
    @JvmName("kefhwgwfauiniaeg")
    public suspend fun appName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appName = mapped
    }

    /**
     * @param value The name of the custom domain resource.
     */
    @JvmName("puvxtyobmeiovhwy")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Properties of the custom domain resource.
     */
    @JvmName("seqkmjdgvjpkfcft")
    public suspend fun properties(`value`: CustomDomainPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the custom domain resource.
     */
    @JvmName("jwudkxwsthvmbsmo")
    public suspend fun properties(argument: suspend CustomDomainPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CustomDomainPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("tasfvfqiksstwyhe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("mokjlprwdvqdrdxw")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): CustomDomainArgs = CustomDomainArgs(
        appName = appName,
        domainName = domainName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
