@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.GatewayPropertiesResponse.Companion.toKotlin as gatewayPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Gateway].
 */
@PulumiTagMarker
public class GatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayArgs = GatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayArgsBuilder.() -> Unit) {
        val builder = GatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Gateway {
        val builtJavaResource = com.pulumi.azurenative.appplatform.Gateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Gateway(builtJavaResource)
    }
}

/**
 * Spring Cloud Gateway resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### Gateways_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gateway = new AzureNative.AppPlatform.Gateway("gateway", new()
 *     {
 *         GatewayName = "default",
 *         Properties = new AzureNative.AppPlatform.Inputs.GatewayPropertiesArgs
 *         {
 *             Public = true,
 *             ResourceRequests = new AzureNative.AppPlatform.Inputs.GatewayResourceRequestsArgs
 *             {
 *                 Cpu = "1",
 *                 Memory = "1G",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "E0",
 *             Tier = "Enterprise",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewGateway(ctx, "gateway", &appplatform.GatewayArgs{
 * 			GatewayName: pulumi.String("default"),
 * 			Properties: appplatform.GatewayPropertiesResponse{
 * 				Public: pulumi.Bool(true),
 * 				ResourceRequests: &appplatform.GatewayResourceRequestsArgs{
 * 					Cpu:    pulumi.String("1"),
 * 					Memory: pulumi.String("1G"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("E0"),
 * 				Tier:     pulumi.String("Enterprise"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Gateway;
 * import com.pulumi.azurenative.appplatform.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gateway = new Gateway("gateway", GatewayArgs.builder()
 *             .gatewayName("default")
 *             .properties(Map.ofEntries(
 *                 Map.entry("public", true),
 *                 Map.entry("resourceRequests", Map.ofEntries(
 *                     Map.entry("cpu", "1"),
 *                     Map.entry("memory", "1G")
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("name", "E0"),
 *                 Map.entry("tier", "Enterprise")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Gateway default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/gateways/{gatewayName}
 * ```
 */
public class Gateway internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.Gateway,
) : KotlinCustomResource(javaResource, GatewayMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Spring Cloud Gateway properties payload
     */
    public val properties: Output<GatewayPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                gatewayPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Sku of the Spring Cloud Gateway resource
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GatewayMapper : ResourceMapper<Gateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.Gateway::class == javaResource::class

    override fun map(javaResource: Resource): Gateway = Gateway(
        javaResource as
            com.pulumi.azurenative.appplatform.Gateway,
    )
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Gateway].
 */
public suspend fun gateway(name: String, block: suspend GatewayResourceBuilder.() -> Unit):
    Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gateway(name: String): Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
