@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.kotlin.outputs.MonitoringSettingPropertiesResponse
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.appplatform.kotlin.outputs.MonitoringSettingPropertiesResponse.Companion.toKotlin as monitoringSettingPropertiesResponseToKotlin
import com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MonitoringSetting].
 */
@PulumiTagMarker
public class MonitoringSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MonitoringSettingArgs = MonitoringSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MonitoringSettingArgsBuilder.() -> Unit) {
        val builder = MonitoringSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MonitoringSetting {
        val builtJavaResource =
            com.pulumi.azurenative.appplatform.MonitoringSetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MonitoringSetting(builtJavaResource)
    }
}

/**
 * Monitoring Setting resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### MonitoringSettings_UpdatePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitoringSetting = new AzureNative.AppPlatform.MonitoringSetting("monitoringSetting", new()
 *     {
 *         Properties = new AzureNative.AppPlatform.Inputs.MonitoringSettingPropertiesArgs
 *         {
 *             AppInsightsInstrumentationKey = "00000000-0000-0000-0000-000000000000",
 *             AppInsightsSamplingRate = 10,
 *             TraceEnabled = true,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewMonitoringSetting(ctx, "monitoringSetting", &appplatform.MonitoringSettingArgs{
 * 			Properties: &appplatform.MonitoringSettingPropertiesArgs{
 * 				AppInsightsInstrumentationKey: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 				AppInsightsSamplingRate:       pulumi.Float64(10),
 * 				TraceEnabled:                  pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.MonitoringSetting;
 * import com.pulumi.azurenative.appplatform.MonitoringSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitoringSetting = new MonitoringSetting("monitoringSetting", MonitoringSettingArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("appInsightsInstrumentationKey", "00000000-0000-0000-0000-000000000000"),
 *                 Map.entry("appInsightsSamplingRate", 10),
 *                 Map.entry("traceEnabled", true)
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:MonitoringSetting default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/monitoringSettings/default
 * ```
 */
public class MonitoringSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.appplatform.MonitoringSetting,
) : KotlinCustomResource(javaResource, MonitoringSettingMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the Monitoring Setting resource
     */
    public val properties: Output<MonitoringSettingPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                monitoringSettingPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MonitoringSettingMapper : ResourceMapper<MonitoringSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.appplatform.MonitoringSetting::class == javaResource::class

    override fun map(javaResource: Resource): MonitoringSetting = MonitoringSetting(
        javaResource as
            com.pulumi.azurenative.appplatform.MonitoringSetting,
    )
}

/**
 * @see [MonitoringSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MonitoringSetting].
 */
public suspend fun monitoringSetting(
    name: String,
    block: suspend MonitoringSettingResourceBuilder.() -> Unit,
): MonitoringSetting {
    val builder = MonitoringSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MonitoringSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun monitoringSetting(name: String): MonitoringSetting {
    val builder = MonitoringSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
